// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model



/**
 * The user-defined preferences that will be applied when updating a provisioned product. Not all preferences are applicable to all provisioned product type
 *
 * One or more AWS accounts that will have access to the provisioned product.
 *
 * Applicable only to a `CFN_STACKSET` provisioned product type.
 *
 * The AWS accounts specified should be within the list of accounts in the `STACKSET` constraint. To get the list of accounts in the `STACKSET` constraint, use the `DescribeProvisioningParameters` operation.
 *
 * If no values are specified, the default value is all accounts from the `STACKSET` constraint.
 */
class ProvisioningPreferences private constructor(builder: Builder) {
    /**
     * One or more AWS accounts where the provisioned product will be available.
     *
     * Applicable only to a `CFN_STACKSET` provisioned product type.
     *
     * The specified accounts should be within the list of accounts from the `STACKSET` constraint. To get the list of accounts in the `STACKSET` constraint, use the `DescribeProvisioningParameters` operation.
     *
     * If no values are specified, the default value is all acounts from the `STACKSET` constraint.
     */
    val stackSetAccounts: List<String>? = builder.stackSetAccounts
    /**
     * The number of accounts, per region, for which this operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions.
     *
     * Applicable only to a `CFN_STACKSET` provisioned product type.
     *
     * Conditional: You must specify either `StackSetFailureToleranceCount` or `StackSetFailureTolerancePercentage`, but not both.
     *
     * The default value is `0` if no value is specified.
     */
    val stackSetFailureToleranceCount: kotlin.Int? = builder.stackSetFailureToleranceCount
    /**
     * The percentage of accounts, per region, for which this stack operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions.
     *
     * When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number.
     *
     * Applicable only to a `CFN_STACKSET` provisioned product type.
     *
     * Conditional: You must specify either `StackSetFailureToleranceCount` or `StackSetFailureTolerancePercentage`, but not both.
     */
    val stackSetFailureTolerancePercentage: kotlin.Int? = builder.stackSetFailureTolerancePercentage
    /**
     * The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of `StackSetFailureToleranceCount`. `StackSetMaxConcurrentCount` is at most one more than the `StackSetFailureToleranceCount`.
     *
     * Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
     *
     * Applicable only to a `CFN_STACKSET` provisioned product type.
     *
     * Conditional: You must specify either `StackSetMaxConcurrentCount` or `StackSetMaxConcurrentPercentage`, but not both.
     */
    val stackSetMaxConcurrencyCount: kotlin.Int? = builder.stackSetMaxConcurrencyCount
    /**
     * The maximum percentage of accounts in which to perform this operation at one time.
     *
     * When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, AWS Service Catalog sets the number as `1` instead.
     *
     * Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
     *
     * Applicable only to a `CFN_STACKSET` provisioned product type.
     *
     * Conditional: You must specify either `StackSetMaxConcurrentCount` or `StackSetMaxConcurrentPercentage`, but not both.
     */
    val stackSetMaxConcurrencyPercentage: kotlin.Int? = builder.stackSetMaxConcurrencyPercentage
    /**
     * One or more AWS Regions where the provisioned product will be available.
     *
     * Applicable only to a `CFN_STACKSET` provisioned product type.
     *
     * The specified regions should be within the list of regions from the `STACKSET` constraint. To get the list of regions in the `STACKSET` constraint, use the `DescribeProvisioningParameters` operation.
     *
     * If no values are specified, the default value is all regions from the `STACKSET` constraint.
     */
    val stackSetRegions: List<String>? = builder.stackSetRegions

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.ProvisioningPreferences = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProvisioningPreferences(")
        append("stackSetAccounts=$stackSetAccounts,")
        append("stackSetFailureToleranceCount=$stackSetFailureToleranceCount,")
        append("stackSetFailureTolerancePercentage=$stackSetFailureTolerancePercentage,")
        append("stackSetMaxConcurrencyCount=$stackSetMaxConcurrencyCount,")
        append("stackSetMaxConcurrencyPercentage=$stackSetMaxConcurrencyPercentage,")
        append("stackSetRegions=$stackSetRegions)")
    }

    override fun hashCode(): kotlin.Int {
        var result = stackSetAccounts?.hashCode() ?: 0
        result = 31 * result + (stackSetFailureToleranceCount ?: 0)
        result = 31 * result + (stackSetFailureTolerancePercentage ?: 0)
        result = 31 * result + (stackSetMaxConcurrencyCount ?: 0)
        result = 31 * result + (stackSetMaxConcurrencyPercentage ?: 0)
        result = 31 * result + (stackSetRegions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProvisioningPreferences

        if (stackSetAccounts != other.stackSetAccounts) return false
        if (stackSetFailureToleranceCount != other.stackSetFailureToleranceCount) return false
        if (stackSetFailureTolerancePercentage != other.stackSetFailureTolerancePercentage) return false
        if (stackSetMaxConcurrencyCount != other.stackSetMaxConcurrencyCount) return false
        if (stackSetMaxConcurrencyPercentage != other.stackSetMaxConcurrencyPercentage) return false
        if (stackSetRegions != other.stackSetRegions) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.ProvisioningPreferences = Builder(this).apply(block).build()

    class Builder {
        /**
         * One or more AWS accounts where the provisioned product will be available.
         *
         * Applicable only to a `CFN_STACKSET` provisioned product type.
         *
         * The specified accounts should be within the list of accounts from the `STACKSET` constraint. To get the list of accounts in the `STACKSET` constraint, use the `DescribeProvisioningParameters` operation.
         *
         * If no values are specified, the default value is all acounts from the `STACKSET` constraint.
         */
        var stackSetAccounts: List<String>? = null
        /**
         * The number of accounts, per region, for which this operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions.
         *
         * Applicable only to a `CFN_STACKSET` provisioned product type.
         *
         * Conditional: You must specify either `StackSetFailureToleranceCount` or `StackSetFailureTolerancePercentage`, but not both.
         *
         * The default value is `0` if no value is specified.
         */
        var stackSetFailureToleranceCount: kotlin.Int? = null
        /**
         * The percentage of accounts, per region, for which this stack operation can fail before AWS Service Catalog stops the operation in that region. If the operation is stopped in a region, AWS Service Catalog doesn't attempt the operation in any subsequent regions.
         *
         * When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number.
         *
         * Applicable only to a `CFN_STACKSET` provisioned product type.
         *
         * Conditional: You must specify either `StackSetFailureToleranceCount` or `StackSetFailureTolerancePercentage`, but not both.
         */
        var stackSetFailureTolerancePercentage: kotlin.Int? = null
        /**
         * The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of `StackSetFailureToleranceCount`. `StackSetMaxConcurrentCount` is at most one more than the `StackSetFailureToleranceCount`.
         *
         * Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
         *
         * Applicable only to a `CFN_STACKSET` provisioned product type.
         *
         * Conditional: You must specify either `StackSetMaxConcurrentCount` or `StackSetMaxConcurrentPercentage`, but not both.
         */
        var stackSetMaxConcurrencyCount: kotlin.Int? = null
        /**
         * The maximum percentage of accounts in which to perform this operation at one time.
         *
         * When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, AWS Service Catalog sets the number as `1` instead.
         *
         * Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
         *
         * Applicable only to a `CFN_STACKSET` provisioned product type.
         *
         * Conditional: You must specify either `StackSetMaxConcurrentCount` or `StackSetMaxConcurrentPercentage`, but not both.
         */
        var stackSetMaxConcurrencyPercentage: kotlin.Int? = null
        /**
         * One or more AWS Regions where the provisioned product will be available.
         *
         * Applicable only to a `CFN_STACKSET` provisioned product type.
         *
         * The specified regions should be within the list of regions from the `STACKSET` constraint. To get the list of regions in the `STACKSET` constraint, use the `DescribeProvisioningParameters` operation.
         *
         * If no values are specified, the default value is all regions from the `STACKSET` constraint.
         */
        var stackSetRegions: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.ProvisioningPreferences) : this() {
            this.stackSetAccounts = x.stackSetAccounts
            this.stackSetFailureToleranceCount = x.stackSetFailureToleranceCount
            this.stackSetFailureTolerancePercentage = x.stackSetFailureTolerancePercentage
            this.stackSetMaxConcurrencyCount = x.stackSetMaxConcurrencyCount
            this.stackSetMaxConcurrencyPercentage = x.stackSetMaxConcurrencyPercentage
            this.stackSetRegions = x.stackSetRegions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.ProvisioningPreferences = ProvisioningPreferences(this)
    }
}
