// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a request operation.
 */
class RecordDetail private constructor(builder: Builder) {
    /**
     * The UTC time stamp of the creation time.
     */
    val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The ARN of the launch role associated with the provisioned product.
     */
    val launchRoleArn: kotlin.String? = builder.launchRoleArn
    /**
     * The path identifier.
     */
    val pathId: kotlin.String? = builder.pathId
    /**
     * The product identifier.
     */
    val productId: kotlin.String? = builder.productId
    /**
     * The identifier of the provisioned product.
     */
    val provisionedProductId: kotlin.String? = builder.provisionedProductId
    /**
     * The user-friendly name of the provisioned product.
     */
    val provisionedProductName: kotlin.String? = builder.provisionedProductName
    /**
     * The type of provisioned product. The supported values are `CFN_STACK` and `CFN_STACKSET`.
     */
    val provisionedProductType: kotlin.String? = builder.provisionedProductType
    /**
     * The identifier of the provisioning artifact.
     */
    val provisioningArtifactId: kotlin.String? = builder.provisioningArtifactId
    /**
     * The errors that occurred.
     */
    val recordErrors: List<RecordError>? = builder.recordErrors
    /**
     * The identifier of the record.
     */
    val recordId: kotlin.String? = builder.recordId
    /**
     * One or more tags.
     */
    val recordTags: List<RecordTag>? = builder.recordTags
    /**
     * The record type.
     * + `PROVISION_PRODUCT`
     * + `UPDATE_PROVISIONED_PRODUCT`
     * + `TERMINATE_PROVISIONED_PRODUCT`
     */
    val recordType: kotlin.String? = builder.recordType
    /**
     * The status of the provisioned product.
     * + `CREATED` - The request was created but the operation has not started.
     * + `IN_PROGRESS` - The requested operation is in progress.
     * + `IN_PROGRESS_IN_ERROR` - The provisioned product is under change but the requested operation failed and some remediation is occurring. For example, a rollback.
     * + `SUCCEEDED` - The requested operation has successfully completed.
     * + `FAILED` - The requested operation has unsuccessfully completed. Investigate using the error messages returned.
     */
    val status: aws.sdk.kotlin.services.servicecatalog.model.RecordStatus? = builder.status
    /**
     * The time when the record was last updated.
     */
    val updatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedTime

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.RecordDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecordDetail(")
        append("createdTime=$createdTime,")
        append("launchRoleArn=$launchRoleArn,")
        append("pathId=$pathId,")
        append("productId=$productId,")
        append("provisionedProductId=$provisionedProductId,")
        append("provisionedProductName=$provisionedProductName,")
        append("provisionedProductType=$provisionedProductType,")
        append("provisioningArtifactId=$provisioningArtifactId,")
        append("recordErrors=$recordErrors,")
        append("recordId=$recordId,")
        append("recordTags=$recordTags,")
        append("recordType=$recordType,")
        append("status=$status,")
        append("updatedTime=$updatedTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdTime?.hashCode() ?: 0
        result = 31 * result + (launchRoleArn?.hashCode() ?: 0)
        result = 31 * result + (pathId?.hashCode() ?: 0)
        result = 31 * result + (productId?.hashCode() ?: 0)
        result = 31 * result + (provisionedProductId?.hashCode() ?: 0)
        result = 31 * result + (provisionedProductName?.hashCode() ?: 0)
        result = 31 * result + (provisionedProductType?.hashCode() ?: 0)
        result = 31 * result + (provisioningArtifactId?.hashCode() ?: 0)
        result = 31 * result + (recordErrors?.hashCode() ?: 0)
        result = 31 * result + (recordId?.hashCode() ?: 0)
        result = 31 * result + (recordTags?.hashCode() ?: 0)
        result = 31 * result + (recordType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecordDetail

        if (createdTime != other.createdTime) return false
        if (launchRoleArn != other.launchRoleArn) return false
        if (pathId != other.pathId) return false
        if (productId != other.productId) return false
        if (provisionedProductId != other.provisionedProductId) return false
        if (provisionedProductName != other.provisionedProductName) return false
        if (provisionedProductType != other.provisionedProductType) return false
        if (provisioningArtifactId != other.provisioningArtifactId) return false
        if (recordErrors != other.recordErrors) return false
        if (recordId != other.recordId) return false
        if (recordTags != other.recordTags) return false
        if (recordType != other.recordType) return false
        if (status != other.status) return false
        if (updatedTime != other.updatedTime) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.RecordDetail = Builder(this).apply(block).build()

    class Builder {
        /**
         * The UTC time stamp of the creation time.
         */
        var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the launch role associated with the provisioned product.
         */
        var launchRoleArn: kotlin.String? = null
        /**
         * The path identifier.
         */
        var pathId: kotlin.String? = null
        /**
         * The product identifier.
         */
        var productId: kotlin.String? = null
        /**
         * The identifier of the provisioned product.
         */
        var provisionedProductId: kotlin.String? = null
        /**
         * The user-friendly name of the provisioned product.
         */
        var provisionedProductName: kotlin.String? = null
        /**
         * The type of provisioned product. The supported values are `CFN_STACK` and `CFN_STACKSET`.
         */
        var provisionedProductType: kotlin.String? = null
        /**
         * The identifier of the provisioning artifact.
         */
        var provisioningArtifactId: kotlin.String? = null
        /**
         * The errors that occurred.
         */
        var recordErrors: List<RecordError>? = null
        /**
         * The identifier of the record.
         */
        var recordId: kotlin.String? = null
        /**
         * One or more tags.
         */
        var recordTags: List<RecordTag>? = null
        /**
         * The record type.
         * + `PROVISION_PRODUCT`
         * + `UPDATE_PROVISIONED_PRODUCT`
         * + `TERMINATE_PROVISIONED_PRODUCT`
         */
        var recordType: kotlin.String? = null
        /**
         * The status of the provisioned product.
         * + `CREATED` - The request was created but the operation has not started.
         * + `IN_PROGRESS` - The requested operation is in progress.
         * + `IN_PROGRESS_IN_ERROR` - The provisioned product is under change but the requested operation failed and some remediation is occurring. For example, a rollback.
         * + `SUCCEEDED` - The requested operation has successfully completed.
         * + `FAILED` - The requested operation has unsuccessfully completed. Investigate using the error messages returned.
         */
        var status: aws.sdk.kotlin.services.servicecatalog.model.RecordStatus? = null
        /**
         * The time when the record was last updated.
         */
        var updatedTime: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.RecordDetail) : this() {
            this.createdTime = x.createdTime
            this.launchRoleArn = x.launchRoleArn
            this.pathId = x.pathId
            this.productId = x.productId
            this.provisionedProductId = x.provisionedProductId
            this.provisionedProductName = x.provisionedProductName
            this.provisionedProductType = x.provisionedProductType
            this.provisioningArtifactId = x.provisioningArtifactId
            this.recordErrors = x.recordErrors
            this.recordId = x.recordId
            this.recordTags = x.recordTags
            this.recordType = x.recordType
            this.status = x.status
            this.updatedTime = x.updatedTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.RecordDetail = RecordDetail(this)
    }
}
