// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model



class SearchProvisionedProductsRequest private constructor(builder: Builder) {
    /**
     * The language code.
     * + `en` - English (default)
     * + `jp` - Japanese
     * + `zh` - Chinese
     */
    val acceptLanguage: kotlin.String? = builder.acceptLanguage
    /**
     * The access level to use to obtain results. The default is `User`.
     */
    val accessLevelFilter: aws.sdk.kotlin.services.servicecatalog.model.AccessLevelFilter? = builder.accessLevelFilter
    /**
     * The search filters.
     *
     * When the key is `SearchQuery`, the searchable fields are `arn`, `createdTime`, `id`, `lastRecordId`, `idempotencyToken`, `name`, `physicalId`, `productId`, `provisioningArtifact`, `type`, `status`, `tags`, `userArn`, `userArnSession`, `lastProvisioningRecordId`, `lastSuccessfulProvisioningRecordId`, `productName`, and `provisioningArtifactName`.
     *
     * Example: `"SearchQuery":["status:AVAILABLE"]`
     */
    val filters: Map<String, List<String>>? = builder.filters
    /**
     * The maximum number of items to return with this call.
     */
    val pageSize: kotlin.Int = builder.pageSize
    /**
     * The page token for the next set of results. To retrieve the first set of results, use null.
     */
    val pageToken: kotlin.String? = builder.pageToken
    /**
     * The sort field. If no value is specified, the results are not sorted. The valid values are `arn`, `id`, `name`, and `lastRecordId`.
     */
    val sortBy: kotlin.String? = builder.sortBy
    /**
     * The sort order. If no value is specified, the results are not sorted.
     */
    val sortOrder: aws.sdk.kotlin.services.servicecatalog.model.SortOrder? = builder.sortOrder

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.SearchProvisionedProductsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchProvisionedProductsRequest(")
        append("acceptLanguage=$acceptLanguage,")
        append("accessLevelFilter=$accessLevelFilter,")
        append("filters=$filters,")
        append("pageSize=$pageSize,")
        append("pageToken=$pageToken,")
        append("sortBy=$sortBy,")
        append("sortOrder=$sortOrder)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptLanguage?.hashCode() ?: 0
        result = 31 * result + (accessLevelFilter?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (pageSize)
        result = 31 * result + (pageToken?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchProvisionedProductsRequest

        if (acceptLanguage != other.acceptLanguage) return false
        if (accessLevelFilter != other.accessLevelFilter) return false
        if (filters != other.filters) return false
        if (pageSize != other.pageSize) return false
        if (pageToken != other.pageToken) return false
        if (sortBy != other.sortBy) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.SearchProvisionedProductsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The language code.
         * + `en` - English (default)
         * + `jp` - Japanese
         * + `zh` - Chinese
         */
        var acceptLanguage: kotlin.String? = null
        /**
         * The access level to use to obtain results. The default is `User`.
         */
        var accessLevelFilter: aws.sdk.kotlin.services.servicecatalog.model.AccessLevelFilter? = null
        /**
         * The search filters.
         *
         * When the key is `SearchQuery`, the searchable fields are `arn`, `createdTime`, `id`, `lastRecordId`, `idempotencyToken`, `name`, `physicalId`, `productId`, `provisioningArtifact`, `type`, `status`, `tags`, `userArn`, `userArnSession`, `lastProvisioningRecordId`, `lastSuccessfulProvisioningRecordId`, `productName`, and `provisioningArtifactName`.
         *
         * Example: `"SearchQuery":["status:AVAILABLE"]`
         */
        var filters: Map<String, List<String>>? = null
        /**
         * The maximum number of items to return with this call.
         */
        var pageSize: kotlin.Int = 0
        /**
         * The page token for the next set of results. To retrieve the first set of results, use null.
         */
        var pageToken: kotlin.String? = null
        /**
         * The sort field. If no value is specified, the results are not sorted. The valid values are `arn`, `id`, `name`, and `lastRecordId`.
         */
        var sortBy: kotlin.String? = null
        /**
         * The sort order. If no value is specified, the results are not sorted.
         */
        var sortOrder: aws.sdk.kotlin.services.servicecatalog.model.SortOrder? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.SearchProvisionedProductsRequest) : this() {
            this.acceptLanguage = x.acceptLanguage
            this.accessLevelFilter = x.accessLevelFilter
            this.filters = x.filters
            this.pageSize = x.pageSize
            this.pageToken = x.pageToken
            this.sortBy = x.sortBy
            this.sortOrder = x.sortOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.SearchProvisionedProductsRequest = SearchProvisionedProductsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.servicecatalog.model.AccessLevelFilter] inside the given [block]
         */
        fun accessLevelFilter(block: aws.sdk.kotlin.services.servicecatalog.model.AccessLevelFilter.Builder.() -> kotlin.Unit) {
            this.accessLevelFilter = aws.sdk.kotlin.services.servicecatalog.model.AccessLevelFilter.invoke(block)
        }
    }
}
