// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model



/**
 * An AWS CloudFormation stack, in a specific account and region, that's part of a stack set operation. A stack instance is a reference to an attempted or actual stack in a given account within a given region. A stack instance can exist without a stack—for example, if the stack couldn't be created for some reason. A stack instance is associated with only one stack set. Each stack instance contains the ID of its associated stack set, as well as the ID of the actual stack and the stack status.
 */
class StackInstance private constructor(builder: Builder) {
    /**
     * The name of the AWS account that the stack instance is associated with.
     */
    val account: kotlin.String? = builder.account
    /**
     * The name of the AWS region that the stack instance is associated with.
     */
    val region: kotlin.String? = builder.region
    /**
     * The status of the stack instance, in terms of its synchronization with its associated stack set.
     * + `INOPERABLE`: A `DeleteStackInstances` operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further `UpdateStackSet` operations. You might need to perform a `DeleteStackInstances` operation, with `RetainStacks` set to true, to delete the stack instance, and then delete the stack manually.
     * + `OUTDATED`: The stack isn't currently up to date with the stack set because either the associated stack failed during a `CreateStackSet` or `UpdateStackSet` operation, or the stack was part of a `CreateStackSet` or `UpdateStackSet` operation that failed or was stopped before the stack was created or updated.
     * + `CURRENT`: The stack is currently up to date with the stack set.
     */
    val stackInstanceStatus: aws.sdk.kotlin.services.servicecatalog.model.StackInstanceStatus? = builder.stackInstanceStatus

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.StackInstance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StackInstance(")
        append("account=$account,")
        append("region=$region,")
        append("stackInstanceStatus=$stackInstanceStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = account?.hashCode() ?: 0
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (stackInstanceStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StackInstance

        if (account != other.account) return false
        if (region != other.region) return false
        if (stackInstanceStatus != other.stackInstanceStatus) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.StackInstance = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the AWS account that the stack instance is associated with.
         */
        var account: kotlin.String? = null
        /**
         * The name of the AWS region that the stack instance is associated with.
         */
        var region: kotlin.String? = null
        /**
         * The status of the stack instance, in terms of its synchronization with its associated stack set.
         * + `INOPERABLE`: A `DeleteStackInstances` operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further `UpdateStackSet` operations. You might need to perform a `DeleteStackInstances` operation, with `RetainStacks` set to true, to delete the stack instance, and then delete the stack manually.
         * + `OUTDATED`: The stack isn't currently up to date with the stack set because either the associated stack failed during a `CreateStackSet` or `UpdateStackSet` operation, or the stack was part of a `CreateStackSet` or `UpdateStackSet` operation that failed or was stopped before the stack was created or updated.
         * + `CURRENT`: The stack is currently up to date with the stack set.
         */
        var stackInstanceStatus: aws.sdk.kotlin.services.servicecatalog.model.StackInstanceStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.StackInstance) : this() {
            this.account = x.account
            this.region = x.region
            this.stackInstanceStatus = x.stackInstanceStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.StackInstance = StackInstance(this)
    }
}
