// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model



class TerminateProvisionedProductRequest private constructor(builder: Builder) {
    /**
     * The language code.
     * + `en` - English (default)
     * + `jp` - Japanese
     * + `zh` - Chinese
     */
    val acceptLanguage: kotlin.String? = builder.acceptLanguage
    /**
     * If set to true, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources.
     */
    val ignoreErrors: kotlin.Boolean = builder.ignoreErrors
    /**
     * The identifier of the provisioned product. You cannot specify both `ProvisionedProductName` and `ProvisionedProductId`.
     */
    val provisionedProductId: kotlin.String? = builder.provisionedProductId
    /**
     * The name of the provisioned product. You cannot specify both `ProvisionedProductName` and `ProvisionedProductId`.
     */
    val provisionedProductName: kotlin.String? = builder.provisionedProductName
    /**
     * When this boolean parameter is set to true, the `TerminateProvisionedProduct` API deletes the Service Catalog provisioned product. However, it does not remove the CloudFormation stack, stack set, or the underlying resources of the deleted provisioned product. The default value is false.
     */
    val retainPhysicalResources: kotlin.Boolean = builder.retainPhysicalResources
    /**
     * An idempotency token that uniquely identifies the termination request. This token is only valid during the termination process. After the provisioned product is terminated, subsequent requests to terminate the same provisioned product always return **ResourceNotFound**.
     */
    val terminateToken: kotlin.String? = builder.terminateToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.TerminateProvisionedProductRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TerminateProvisionedProductRequest(")
        append("acceptLanguage=$acceptLanguage,")
        append("ignoreErrors=$ignoreErrors,")
        append("provisionedProductId=$provisionedProductId,")
        append("provisionedProductName=$provisionedProductName,")
        append("retainPhysicalResources=$retainPhysicalResources,")
        append("terminateToken=$terminateToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptLanguage?.hashCode() ?: 0
        result = 31 * result + (ignoreErrors.hashCode())
        result = 31 * result + (provisionedProductId?.hashCode() ?: 0)
        result = 31 * result + (provisionedProductName?.hashCode() ?: 0)
        result = 31 * result + (retainPhysicalResources.hashCode())
        result = 31 * result + (terminateToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TerminateProvisionedProductRequest

        if (acceptLanguage != other.acceptLanguage) return false
        if (ignoreErrors != other.ignoreErrors) return false
        if (provisionedProductId != other.provisionedProductId) return false
        if (provisionedProductName != other.provisionedProductName) return false
        if (retainPhysicalResources != other.retainPhysicalResources) return false
        if (terminateToken != other.terminateToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.TerminateProvisionedProductRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The language code.
         * + `en` - English (default)
         * + `jp` - Japanese
         * + `zh` - Chinese
         */
        var acceptLanguage: kotlin.String? = null
        /**
         * If set to true, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources.
         */
        var ignoreErrors: kotlin.Boolean = false
        /**
         * The identifier of the provisioned product. You cannot specify both `ProvisionedProductName` and `ProvisionedProductId`.
         */
        var provisionedProductId: kotlin.String? = null
        /**
         * The name of the provisioned product. You cannot specify both `ProvisionedProductName` and `ProvisionedProductId`.
         */
        var provisionedProductName: kotlin.String? = null
        /**
         * When this boolean parameter is set to true, the `TerminateProvisionedProduct` API deletes the Service Catalog provisioned product. However, it does not remove the CloudFormation stack, stack set, or the underlying resources of the deleted provisioned product. The default value is false.
         */
        var retainPhysicalResources: kotlin.Boolean = false
        /**
         * An idempotency token that uniquely identifies the termination request. This token is only valid during the termination process. After the provisioned product is terminated, subsequent requests to terminate the same provisioned product always return **ResourceNotFound**.
         */
        var terminateToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.TerminateProvisionedProductRequest) : this() {
            this.acceptLanguage = x.acceptLanguage
            this.ignoreErrors = x.ignoreErrors
            this.provisionedProductId = x.provisionedProductId
            this.provisionedProductName = x.provisionedProductName
            this.retainPhysicalResources = x.retainPhysicalResources
            this.terminateToken = x.terminateToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.TerminateProvisionedProductRequest = TerminateProvisionedProductRequest(this)
    }
}
