// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model



class UpdateProvisionedProductPropertiesRequest private constructor(builder: Builder) {
    /**
     * The language code.
     * + `en` - English (default)
     * + `jp` - Japanese
     * + `zh` - Chinese
     */
    val acceptLanguage: kotlin.String? = builder.acceptLanguage
    /**
     * The idempotency token that uniquely identifies the provisioning product update request.
     */
    val idempotencyToken: kotlin.String? = builder.idempotencyToken
    /**
     * The identifier of the provisioned product.
     */
    val provisionedProductId: kotlin.String? = builder.provisionedProductId
    /**
     * A map that contains the provisioned product properties to be updated.
     *
     * The `LAUNCH_ROLE` key accepts role ARNs. This key allows an administrator to call `UpdateProvisionedProductProperties` to update the launch role that is associated with a provisioned product. This role is used when an end user calls a provisioning operation such as `UpdateProvisionedProduct`, `TerminateProvisionedProduct`, or `ExecuteProvisionedProductServiceAction`. Only a role ARN is valid. A user ARN is invalid.
     *
     * The `OWNER` key accepts user ARNs and role ARNs. The owner is the user that has permission to see, update, terminate, and execute service actions in the provisioned product.
     *
     * The administrator can change the owner of a provisioned product to another IAM user within the same account. Both end user owners and administrators can see ownership history of the provisioned product using the `ListRecordHistory` API. The new owner can describe all past records for the provisioned product using the `DescribeRecord` API. The previous owner can no longer use `DescribeRecord`, but can still see the product's history from when he was an owner using `ListRecordHistory`.
     *
     * If a provisioned product ownership is assigned to an end user, they can see and perform any action through the API or Service Catalog console such as update, terminate, and execute service actions. If an end user provisions a product and the owner is updated to someone else, they will no longer be able to see or perform any actions through API or the Service Catalog console on that provisioned product.
     */
    val provisionedProductProperties: Map<String, String>? = builder.provisionedProductProperties

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.UpdateProvisionedProductPropertiesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateProvisionedProductPropertiesRequest(")
        append("acceptLanguage=$acceptLanguage,")
        append("idempotencyToken=$idempotencyToken,")
        append("provisionedProductId=$provisionedProductId,")
        append("provisionedProductProperties=$provisionedProductProperties)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptLanguage?.hashCode() ?: 0
        result = 31 * result + (idempotencyToken?.hashCode() ?: 0)
        result = 31 * result + (provisionedProductId?.hashCode() ?: 0)
        result = 31 * result + (provisionedProductProperties?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateProvisionedProductPropertiesRequest

        if (acceptLanguage != other.acceptLanguage) return false
        if (idempotencyToken != other.idempotencyToken) return false
        if (provisionedProductId != other.provisionedProductId) return false
        if (provisionedProductProperties != other.provisionedProductProperties) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.UpdateProvisionedProductPropertiesRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The language code.
         * + `en` - English (default)
         * + `jp` - Japanese
         * + `zh` - Chinese
         */
        var acceptLanguage: kotlin.String? = null
        /**
         * The idempotency token that uniquely identifies the provisioning product update request.
         */
        var idempotencyToken: kotlin.String? = null
        /**
         * The identifier of the provisioned product.
         */
        var provisionedProductId: kotlin.String? = null
        /**
         * A map that contains the provisioned product properties to be updated.
         *
         * The `LAUNCH_ROLE` key accepts role ARNs. This key allows an administrator to call `UpdateProvisionedProductProperties` to update the launch role that is associated with a provisioned product. This role is used when an end user calls a provisioning operation such as `UpdateProvisionedProduct`, `TerminateProvisionedProduct`, or `ExecuteProvisionedProductServiceAction`. Only a role ARN is valid. A user ARN is invalid.
         *
         * The `OWNER` key accepts user ARNs and role ARNs. The owner is the user that has permission to see, update, terminate, and execute service actions in the provisioned product.
         *
         * The administrator can change the owner of a provisioned product to another IAM user within the same account. Both end user owners and administrators can see ownership history of the provisioned product using the `ListRecordHistory` API. The new owner can describe all past records for the provisioned product using the `DescribeRecord` API. The previous owner can no longer use `DescribeRecord`, but can still see the product's history from when he was an owner using `ListRecordHistory`.
         *
         * If a provisioned product ownership is assigned to an end user, they can see and perform any action through the API or Service Catalog console such as update, terminate, and execute service actions. If an end user provisions a product and the owner is updated to someone else, they will no longer be able to see or perform any actions through API or the Service Catalog console on that provisioned product.
         */
        var provisionedProductProperties: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.UpdateProvisionedProductPropertiesRequest) : this() {
            this.acceptLanguage = x.acceptLanguage
            this.idempotencyToken = x.idempotencyToken
            this.provisionedProductId = x.provisionedProductId
            this.provisionedProductProperties = x.provisionedProductProperties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.UpdateProvisionedProductPropertiesRequest = UpdateProvisionedProductPropertiesRequest(this)
    }
}
