// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.paginators

import aws.sdk.kotlin.services.servicecatalog.ServiceCatalogClient
import aws.sdk.kotlin.services.servicecatalog.model.DescribePortfolioSharesRequest
import aws.sdk.kotlin.services.servicecatalog.model.DescribePortfolioSharesResponse
import aws.sdk.kotlin.services.servicecatalog.model.GetProvisionedProductOutputsRequest
import aws.sdk.kotlin.services.servicecatalog.model.GetProvisionedProductOutputsResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListBudgetsForResourceRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListBudgetsForResourceResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListConstraintsForPortfolioRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListConstraintsForPortfolioResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListLaunchPathsRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListLaunchPathsResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListOrganizationPortfolioAccessResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListPortfolioAccessRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListPortfolioAccessResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListPortfoliosForProductRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListPortfoliosForProductResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListPortfoliosRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListPortfoliosResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListPrincipalsForPortfolioRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListPrincipalsForPortfolioResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListResourcesForTagOptionRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListResourcesForTagOptionResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListServiceActionsRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListServiceActionsResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListTagOptionsRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListTagOptionsResponse
import aws.sdk.kotlin.services.servicecatalog.model.SearchProductsAsAdminRequest
import aws.sdk.kotlin.services.servicecatalog.model.SearchProductsAsAdminResponse
import aws.sdk.kotlin.services.servicecatalog.model.SearchProductsRequest
import aws.sdk.kotlin.services.servicecatalog.model.SearchProductsResponse
import aws.sdk.kotlin.services.servicecatalog.model.SearchProvisionedProductsRequest
import aws.sdk.kotlin.services.servicecatalog.model.SearchProvisionedProductsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [DescribePortfolioSharesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribePortfolioSharesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePortfolioSharesResponse]
 */
fun ServiceCatalogClient.describePortfolioSharesPaginated(initialRequest: DescribePortfolioSharesRequest): Flow<DescribePortfolioSharesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.pageToken = cursor
            }
            val result = this@describePortfolioSharesPaginated.describePortfolioShares(req)
            isFirstPage = false
            cursor = result.nextPageToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribePortfolioSharesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePortfolioSharesResponse]
 */
fun ServiceCatalogClient.describePortfolioSharesPaginated(block: DescribePortfolioSharesRequest.Builder.() -> Unit): Flow<DescribePortfolioSharesResponse> =
    describePortfolioSharesPaginated(DescribePortfolioSharesRequest.Builder().apply(block).build())

/**
 * Paginate over [GetProvisionedProductOutputsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetProvisionedProductOutputsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetProvisionedProductOutputsResponse]
 */
fun ServiceCatalogClient.getProvisionedProductOutputsPaginated(initialRequest: GetProvisionedProductOutputsRequest): Flow<GetProvisionedProductOutputsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.pageToken = cursor
            }
            val result = this@getProvisionedProductOutputsPaginated.getProvisionedProductOutputs(req)
            isFirstPage = false
            cursor = result.nextPageToken
            emit(result)
        }
    }

/**
 * Paginate over [GetProvisionedProductOutputsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetProvisionedProductOutputsResponse]
 */
fun ServiceCatalogClient.getProvisionedProductOutputsPaginated(block: GetProvisionedProductOutputsRequest.Builder.() -> Unit): Flow<GetProvisionedProductOutputsResponse> =
    getProvisionedProductOutputsPaginated(GetProvisionedProductOutputsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAcceptedPortfolioSharesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAcceptedPortfolioSharesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAcceptedPortfolioSharesResponse]
 */
fun ServiceCatalogClient.listAcceptedPortfolioSharesPaginated(initialRequest: ListAcceptedPortfolioSharesRequest): Flow<ListAcceptedPortfolioSharesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.pageToken = cursor
            }
            val result = this@listAcceptedPortfolioSharesPaginated.listAcceptedPortfolioShares(req)
            isFirstPage = false
            cursor = result.nextPageToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAcceptedPortfolioSharesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAcceptedPortfolioSharesResponse]
 */
fun ServiceCatalogClient.listAcceptedPortfolioSharesPaginated(block: ListAcceptedPortfolioSharesRequest.Builder.() -> Unit): Flow<ListAcceptedPortfolioSharesResponse> =
    listAcceptedPortfolioSharesPaginated(ListAcceptedPortfolioSharesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListBudgetsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBudgetsForResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBudgetsForResourceResponse]
 */
fun ServiceCatalogClient.listBudgetsForResourcePaginated(initialRequest: ListBudgetsForResourceRequest): Flow<ListBudgetsForResourceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.pageToken = cursor
            }
            val result = this@listBudgetsForResourcePaginated.listBudgetsForResource(req)
            isFirstPage = false
            cursor = result.nextPageToken
            emit(result)
        }
    }

/**
 * Paginate over [ListBudgetsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBudgetsForResourceResponse]
 */
fun ServiceCatalogClient.listBudgetsForResourcePaginated(block: ListBudgetsForResourceRequest.Builder.() -> Unit): Flow<ListBudgetsForResourceResponse> =
    listBudgetsForResourcePaginated(ListBudgetsForResourceRequest.Builder().apply(block).build())

/**
 * Paginate over [ListConstraintsForPortfolioResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListConstraintsForPortfolioRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConstraintsForPortfolioResponse]
 */
fun ServiceCatalogClient.listConstraintsForPortfolioPaginated(initialRequest: ListConstraintsForPortfolioRequest): Flow<ListConstraintsForPortfolioResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.pageToken = cursor
            }
            val result = this@listConstraintsForPortfolioPaginated.listConstraintsForPortfolio(req)
            isFirstPage = false
            cursor = result.nextPageToken
            emit(result)
        }
    }

/**
 * Paginate over [ListConstraintsForPortfolioResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConstraintsForPortfolioResponse]
 */
fun ServiceCatalogClient.listConstraintsForPortfolioPaginated(block: ListConstraintsForPortfolioRequest.Builder.() -> Unit): Flow<ListConstraintsForPortfolioResponse> =
    listConstraintsForPortfolioPaginated(ListConstraintsForPortfolioRequest.Builder().apply(block).build())

/**
 * Paginate over [ListLaunchPathsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLaunchPathsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLaunchPathsResponse]
 */
fun ServiceCatalogClient.listLaunchPathsPaginated(initialRequest: ListLaunchPathsRequest): Flow<ListLaunchPathsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.pageToken = cursor
            }
            val result = this@listLaunchPathsPaginated.listLaunchPaths(req)
            isFirstPage = false
            cursor = result.nextPageToken
            emit(result)
        }
    }

/**
 * Paginate over [ListLaunchPathsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLaunchPathsResponse]
 */
fun ServiceCatalogClient.listLaunchPathsPaginated(block: ListLaunchPathsRequest.Builder.() -> Unit): Flow<ListLaunchPathsResponse> =
    listLaunchPathsPaginated(ListLaunchPathsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListOrganizationPortfolioAccessResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListOrganizationPortfolioAccessRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOrganizationPortfolioAccessResponse]
 */
fun ServiceCatalogClient.listOrganizationPortfolioAccessPaginated(initialRequest: ListOrganizationPortfolioAccessRequest): Flow<ListOrganizationPortfolioAccessResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.pageToken = cursor
            }
            val result = this@listOrganizationPortfolioAccessPaginated.listOrganizationPortfolioAccess(req)
            isFirstPage = false
            cursor = result.nextPageToken
            emit(result)
        }
    }

/**
 * Paginate over [ListOrganizationPortfolioAccessResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOrganizationPortfolioAccessResponse]
 */
fun ServiceCatalogClient.listOrganizationPortfolioAccessPaginated(block: ListOrganizationPortfolioAccessRequest.Builder.() -> Unit): Flow<ListOrganizationPortfolioAccessResponse> =
    listOrganizationPortfolioAccessPaginated(ListOrganizationPortfolioAccessRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPortfolioAccessResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPortfolioAccessRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPortfolioAccessResponse]
 */
fun ServiceCatalogClient.listPortfolioAccessPaginated(initialRequest: ListPortfolioAccessRequest): Flow<ListPortfolioAccessResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.pageToken = cursor
            }
            val result = this@listPortfolioAccessPaginated.listPortfolioAccess(req)
            isFirstPage = false
            cursor = result.nextPageToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPortfolioAccessResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPortfolioAccessResponse]
 */
fun ServiceCatalogClient.listPortfolioAccessPaginated(block: ListPortfolioAccessRequest.Builder.() -> Unit): Flow<ListPortfolioAccessResponse> =
    listPortfolioAccessPaginated(ListPortfolioAccessRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPortfoliosResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPortfoliosRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPortfoliosResponse]
 */
fun ServiceCatalogClient.listPortfoliosPaginated(initialRequest: ListPortfoliosRequest): Flow<ListPortfoliosResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.pageToken = cursor
            }
            val result = this@listPortfoliosPaginated.listPortfolios(req)
            isFirstPage = false
            cursor = result.nextPageToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPortfoliosResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPortfoliosResponse]
 */
fun ServiceCatalogClient.listPortfoliosPaginated(block: ListPortfoliosRequest.Builder.() -> Unit): Flow<ListPortfoliosResponse> =
    listPortfoliosPaginated(ListPortfoliosRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPortfoliosForProductResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPortfoliosForProductRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPortfoliosForProductResponse]
 */
fun ServiceCatalogClient.listPortfoliosForProductPaginated(initialRequest: ListPortfoliosForProductRequest): Flow<ListPortfoliosForProductResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.pageToken = cursor
            }
            val result = this@listPortfoliosForProductPaginated.listPortfoliosForProduct(req)
            isFirstPage = false
            cursor = result.nextPageToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPortfoliosForProductResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPortfoliosForProductResponse]
 */
fun ServiceCatalogClient.listPortfoliosForProductPaginated(block: ListPortfoliosForProductRequest.Builder.() -> Unit): Flow<ListPortfoliosForProductResponse> =
    listPortfoliosForProductPaginated(ListPortfoliosForProductRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPrincipalsForPortfolioResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPrincipalsForPortfolioRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPrincipalsForPortfolioResponse]
 */
fun ServiceCatalogClient.listPrincipalsForPortfolioPaginated(initialRequest: ListPrincipalsForPortfolioRequest): Flow<ListPrincipalsForPortfolioResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.pageToken = cursor
            }
            val result = this@listPrincipalsForPortfolioPaginated.listPrincipalsForPortfolio(req)
            isFirstPage = false
            cursor = result.nextPageToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPrincipalsForPortfolioResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPrincipalsForPortfolioResponse]
 */
fun ServiceCatalogClient.listPrincipalsForPortfolioPaginated(block: ListPrincipalsForPortfolioRequest.Builder.() -> Unit): Flow<ListPrincipalsForPortfolioResponse> =
    listPrincipalsForPortfolioPaginated(ListPrincipalsForPortfolioRequest.Builder().apply(block).build())

/**
 * Paginate over [ListProvisioningArtifactsForServiceActionResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProvisioningArtifactsForServiceActionRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProvisioningArtifactsForServiceActionResponse]
 */
fun ServiceCatalogClient.listProvisioningArtifactsForServiceActionPaginated(initialRequest: ListProvisioningArtifactsForServiceActionRequest): Flow<ListProvisioningArtifactsForServiceActionResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.pageToken = cursor
            }
            val result = this@listProvisioningArtifactsForServiceActionPaginated.listProvisioningArtifactsForServiceAction(req)
            isFirstPage = false
            cursor = result.nextPageToken
            emit(result)
        }
    }

/**
 * Paginate over [ListProvisioningArtifactsForServiceActionResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProvisioningArtifactsForServiceActionResponse]
 */
fun ServiceCatalogClient.listProvisioningArtifactsForServiceActionPaginated(block: ListProvisioningArtifactsForServiceActionRequest.Builder.() -> Unit): Flow<ListProvisioningArtifactsForServiceActionResponse> =
    listProvisioningArtifactsForServiceActionPaginated(ListProvisioningArtifactsForServiceActionRequest.Builder().apply(block).build())

/**
 * Paginate over [ListResourcesForTagOptionResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResourcesForTagOptionRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourcesForTagOptionResponse]
 */
fun ServiceCatalogClient.listResourcesForTagOptionPaginated(initialRequest: ListResourcesForTagOptionRequest): Flow<ListResourcesForTagOptionResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.pageToken = cursor
            }
            val result = this@listResourcesForTagOptionPaginated.listResourcesForTagOption(req)
            isFirstPage = false
            cursor = result.pageToken
            emit(result)
        }
    }

/**
 * Paginate over [ListResourcesForTagOptionResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourcesForTagOptionResponse]
 */
fun ServiceCatalogClient.listResourcesForTagOptionPaginated(block: ListResourcesForTagOptionRequest.Builder.() -> Unit): Flow<ListResourcesForTagOptionResponse> =
    listResourcesForTagOptionPaginated(ListResourcesForTagOptionRequest.Builder().apply(block).build())

/**
 * Paginate over [ListServiceActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListServiceActionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServiceActionsResponse]
 */
fun ServiceCatalogClient.listServiceActionsPaginated(initialRequest: ListServiceActionsRequest): Flow<ListServiceActionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.pageToken = cursor
            }
            val result = this@listServiceActionsPaginated.listServiceActions(req)
            isFirstPage = false
            cursor = result.nextPageToken
            emit(result)
        }
    }

/**
 * Paginate over [ListServiceActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServiceActionsResponse]
 */
fun ServiceCatalogClient.listServiceActionsPaginated(block: ListServiceActionsRequest.Builder.() -> Unit): Flow<ListServiceActionsResponse> =
    listServiceActionsPaginated(ListServiceActionsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListServiceActionsForProvisioningArtifactResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListServiceActionsForProvisioningArtifactRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServiceActionsForProvisioningArtifactResponse]
 */
fun ServiceCatalogClient.listServiceActionsForProvisioningArtifactPaginated(initialRequest: ListServiceActionsForProvisioningArtifactRequest): Flow<ListServiceActionsForProvisioningArtifactResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.pageToken = cursor
            }
            val result = this@listServiceActionsForProvisioningArtifactPaginated.listServiceActionsForProvisioningArtifact(req)
            isFirstPage = false
            cursor = result.nextPageToken
            emit(result)
        }
    }

/**
 * Paginate over [ListServiceActionsForProvisioningArtifactResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServiceActionsForProvisioningArtifactResponse]
 */
fun ServiceCatalogClient.listServiceActionsForProvisioningArtifactPaginated(block: ListServiceActionsForProvisioningArtifactRequest.Builder.() -> Unit): Flow<ListServiceActionsForProvisioningArtifactResponse> =
    listServiceActionsForProvisioningArtifactPaginated(ListServiceActionsForProvisioningArtifactRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTagOptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagOptionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagOptionsResponse]
 */
fun ServiceCatalogClient.listTagOptionsPaginated(initialRequest: ListTagOptionsRequest): Flow<ListTagOptionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.pageToken = cursor
            }
            val result = this@listTagOptionsPaginated.listTagOptions(req)
            isFirstPage = false
            cursor = result.pageToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTagOptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagOptionsResponse]
 */
fun ServiceCatalogClient.listTagOptionsPaginated(block: ListTagOptionsRequest.Builder.() -> Unit): Flow<ListTagOptionsResponse> =
    listTagOptionsPaginated(ListTagOptionsRequest.Builder().apply(block).build())

/**
 * Paginate over [SearchProductsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchProductsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchProductsResponse]
 */
fun ServiceCatalogClient.searchProductsPaginated(initialRequest: SearchProductsRequest): Flow<SearchProductsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.pageToken = cursor
            }
            val result = this@searchProductsPaginated.searchProducts(req)
            isFirstPage = false
            cursor = result.nextPageToken
            emit(result)
        }
    }

/**
 * Paginate over [SearchProductsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchProductsResponse]
 */
fun ServiceCatalogClient.searchProductsPaginated(block: SearchProductsRequest.Builder.() -> Unit): Flow<SearchProductsResponse> =
    searchProductsPaginated(SearchProductsRequest.Builder().apply(block).build())

/**
 * Paginate over [SearchProductsAsAdminResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchProductsAsAdminRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchProductsAsAdminResponse]
 */
fun ServiceCatalogClient.searchProductsAsAdminPaginated(initialRequest: SearchProductsAsAdminRequest): Flow<SearchProductsAsAdminResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.pageToken = cursor
            }
            val result = this@searchProductsAsAdminPaginated.searchProductsAsAdmin(req)
            isFirstPage = false
            cursor = result.nextPageToken
            emit(result)
        }
    }

/**
 * Paginate over [SearchProductsAsAdminResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchProductsAsAdminResponse]
 */
fun ServiceCatalogClient.searchProductsAsAdminPaginated(block: SearchProductsAsAdminRequest.Builder.() -> Unit): Flow<SearchProductsAsAdminResponse> =
    searchProductsAsAdminPaginated(SearchProductsAsAdminRequest.Builder().apply(block).build())

/**
 * Paginate over [SearchProvisionedProductsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchProvisionedProductsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchProvisionedProductsResponse]
 */
fun ServiceCatalogClient.searchProvisionedProductsPaginated(initialRequest: SearchProvisionedProductsRequest): Flow<SearchProvisionedProductsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.pageToken = cursor
            }
            val result = this@searchProvisionedProductsPaginated.searchProvisionedProducts(req)
            isFirstPage = false
            cursor = result.nextPageToken
            emit(result)
        }
    }

/**
 * Paginate over [SearchProvisionedProductsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchProvisionedProductsResponse]
 */
fun ServiceCatalogClient.searchProvisionedProductsPaginated(block: SearchProvisionedProductsRequest.Builder.() -> Unit): Flow<SearchProvisionedProductsResponse> =
    searchProvisionedProductsPaginated(SearchProvisionedProductsRequest.Builder().apply(block).build())
