// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.servicecatalog.model.CreateProvisionedProductPlanResponse
import aws.sdk.kotlin.services.servicecatalog.model.ServiceCatalogException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateProvisionedProductPlanOperationDeserializer: HttpDeserialize<CreateProvisionedProductPlanResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateProvisionedProductPlanResponse {
        if (!response.status.isSuccess()) {
            throwCreateProvisionedProductPlanError(context, response)
        }
        val builder = CreateProvisionedProductPlanResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateProvisionedProductPlanOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateProvisionedProductPlanError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceCatalogException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParametersException" -> InvalidParametersExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidStateException" -> InvalidStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ServiceCatalogException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateProvisionedProductPlanOperationBody(builder: CreateProvisionedProductPlanResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PLANID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PlanId"))
    val PLANNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PlanName"))
    val PROVISIONPRODUCTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProvisionProductId"))
    val PROVISIONEDPRODUCTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProvisionedProductName"))
    val PROVISIONINGARTIFACTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProvisioningArtifactId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PLANID_DESCRIPTOR)
        field(PLANNAME_DESCRIPTOR)
        field(PROVISIONPRODUCTID_DESCRIPTOR)
        field(PROVISIONEDPRODUCTNAME_DESCRIPTOR)
        field(PROVISIONINGARTIFACTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PLANID_DESCRIPTOR.index -> builder.planId = deserializeString()
                PLANNAME_DESCRIPTOR.index -> builder.planName = deserializeString()
                PROVISIONPRODUCTID_DESCRIPTOR.index -> builder.provisionProductId = deserializeString()
                PROVISIONEDPRODUCTNAME_DESCRIPTOR.index -> builder.provisionedProductName = deserializeString()
                PROVISIONINGARTIFACTID_DESCRIPTOR.index -> builder.provisioningArtifactId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
