// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.servicecatalog.model.BudgetDetail
import aws.sdk.kotlin.services.servicecatalog.model.DescribePortfolioResponse
import aws.sdk.kotlin.services.servicecatalog.model.PortfolioDetail
import aws.sdk.kotlin.services.servicecatalog.model.ServiceCatalogException
import aws.sdk.kotlin.services.servicecatalog.model.Tag
import aws.sdk.kotlin.services.servicecatalog.model.TagOptionDetail
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribePortfolioOperationDeserializer: HttpDeserialize<DescribePortfolioResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribePortfolioResponse {
        if (!response.status.isSuccess()) {
            throwDescribePortfolioError(context, response)
        }
        val builder = DescribePortfolioResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribePortfolioOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribePortfolioError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceCatalogException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ServiceCatalogException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribePortfolioOperationBody(builder: DescribePortfolioResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BUDGETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Budgets"))
    val PORTFOLIODETAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PortfolioDetail"))
    val TAGOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TagOptions"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BUDGETS_DESCRIPTOR)
        field(PORTFOLIODETAIL_DESCRIPTOR)
        field(TAGOPTIONS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BUDGETS_DESCRIPTOR.index -> builder.budgets =
                    deserializer.deserializeList(BUDGETS_DESCRIPTOR) {
                        val col0 = mutableListOf<BudgetDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBudgetDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PORTFOLIODETAIL_DESCRIPTOR.index -> builder.portfolioDetail = deserializePortfolioDetailDocument(deserializer)
                TAGOPTIONS_DESCRIPTOR.index -> builder.tagOptions =
                    deserializer.deserializeList(TAGOPTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<TagOptionDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagOptionDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
