// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.servicecatalog.model.DescribePortfolioShareStatusResponse
import aws.sdk.kotlin.services.servicecatalog.model.ServiceCatalogException
import aws.sdk.kotlin.services.servicecatalog.model.ShareDetails
import aws.sdk.kotlin.services.servicecatalog.model.ShareStatus
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribePortfolioShareStatusOperationDeserializer: HttpDeserialize<DescribePortfolioShareStatusResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribePortfolioShareStatusResponse {
        if (!response.status.isSuccess()) {
            throwDescribePortfolioShareStatusError(context, response)
        }
        val builder = DescribePortfolioShareStatusResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribePortfolioShareStatusOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribePortfolioShareStatusError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceCatalogException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParametersException" -> InvalidParametersExceptionDeserializer().deserialize(context, wrappedResponse)
        "OperationNotSupportedException" -> OperationNotSupportedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ServiceCatalogException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribePortfolioShareStatusOperationBody(builder: DescribePortfolioShareStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ORGANIZATIONNODEVALUE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OrganizationNodeValue"))
    val PORTFOLIOID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PortfolioId"))
    val PORTFOLIOSHARETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PortfolioShareToken"))
    val SHAREDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ShareDetails"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ORGANIZATIONNODEVALUE_DESCRIPTOR)
        field(PORTFOLIOID_DESCRIPTOR)
        field(PORTFOLIOSHARETOKEN_DESCRIPTOR)
        field(SHAREDETAILS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ORGANIZATIONNODEVALUE_DESCRIPTOR.index -> builder.organizationNodeValue = deserializeString()
                PORTFOLIOID_DESCRIPTOR.index -> builder.portfolioId = deserializeString()
                PORTFOLIOSHARETOKEN_DESCRIPTOR.index -> builder.portfolioShareToken = deserializeString()
                SHAREDETAILS_DESCRIPTOR.index -> builder.shareDetails = deserializeShareDetailsDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ShareStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
