// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.servicecatalog.model.BudgetDetail
import aws.sdk.kotlin.services.servicecatalog.model.DescribeProductAsAdminResponse
import aws.sdk.kotlin.services.servicecatalog.model.ProductViewDetail
import aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactSummary
import aws.sdk.kotlin.services.servicecatalog.model.ServiceCatalogException
import aws.sdk.kotlin.services.servicecatalog.model.Tag
import aws.sdk.kotlin.services.servicecatalog.model.TagOptionDetail
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeProductAsAdminOperationDeserializer: HttpDeserialize<DescribeProductAsAdminResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeProductAsAdminResponse {
        if (!response.status.isSuccess()) {
            throwDescribeProductAsAdminError(context, response)
        }
        val builder = DescribeProductAsAdminResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeProductAsAdminOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeProductAsAdminError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceCatalogException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParametersException" -> InvalidParametersExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ServiceCatalogException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeProductAsAdminOperationBody(builder: DescribeProductAsAdminResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BUDGETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Budgets"))
    val PRODUCTVIEWDETAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ProductViewDetail"))
    val PROVISIONINGARTIFACTSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProvisioningArtifactSummaries"))
    val TAGOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TagOptions"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BUDGETS_DESCRIPTOR)
        field(PRODUCTVIEWDETAIL_DESCRIPTOR)
        field(PROVISIONINGARTIFACTSUMMARIES_DESCRIPTOR)
        field(TAGOPTIONS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BUDGETS_DESCRIPTOR.index -> builder.budgets =
                    deserializer.deserializeList(BUDGETS_DESCRIPTOR) {
                        val col0 = mutableListOf<BudgetDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBudgetDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PRODUCTVIEWDETAIL_DESCRIPTOR.index -> builder.productViewDetail = deserializeProductViewDetailDocument(deserializer)
                PROVISIONINGARTIFACTSUMMARIES_DESCRIPTOR.index -> builder.provisioningArtifactSummaries =
                    deserializer.deserializeList(PROVISIONINGARTIFACTSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<ProvisioningArtifactSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProvisioningArtifactSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TAGOPTIONS_DESCRIPTOR.index -> builder.tagOptions =
                    deserializer.deserializeList(TAGOPTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<TagOptionDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagOptionDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
