// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.servicecatalog.model.BudgetDetail
import aws.sdk.kotlin.services.servicecatalog.model.DescribeProductResponse
import aws.sdk.kotlin.services.servicecatalog.model.LaunchPath
import aws.sdk.kotlin.services.servicecatalog.model.ProductViewSummary
import aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifact
import aws.sdk.kotlin.services.servicecatalog.model.ServiceCatalogException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeProductOperationDeserializer: HttpDeserialize<DescribeProductResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeProductResponse {
        if (!response.status.isSuccess()) {
            throwDescribeProductError(context, response)
        }
        val builder = DescribeProductResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeProductOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeProductError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceCatalogException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParametersException" -> InvalidParametersExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ServiceCatalogException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeProductOperationBody(builder: DescribeProductResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BUDGETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Budgets"))
    val LAUNCHPATHS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("LaunchPaths"))
    val PRODUCTVIEWSUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ProductViewSummary"))
    val PROVISIONINGARTIFACTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProvisioningArtifacts"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BUDGETS_DESCRIPTOR)
        field(LAUNCHPATHS_DESCRIPTOR)
        field(PRODUCTVIEWSUMMARY_DESCRIPTOR)
        field(PROVISIONINGARTIFACTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BUDGETS_DESCRIPTOR.index -> builder.budgets =
                    deserializer.deserializeList(BUDGETS_DESCRIPTOR) {
                        val col0 = mutableListOf<BudgetDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBudgetDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LAUNCHPATHS_DESCRIPTOR.index -> builder.launchPaths =
                    deserializer.deserializeList(LAUNCHPATHS_DESCRIPTOR) {
                        val col0 = mutableListOf<LaunchPath>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeLaunchPathDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PRODUCTVIEWSUMMARY_DESCRIPTOR.index -> builder.productViewSummary = deserializeProductViewSummaryDocument(deserializer)
                PROVISIONINGARTIFACTS_DESCRIPTOR.index -> builder.provisioningArtifacts =
                    deserializer.deserializeList(PROVISIONINGARTIFACTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ProvisioningArtifact>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProvisioningArtifactDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
