// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.servicecatalog.model.CloudWatchDashboard
import aws.sdk.kotlin.services.servicecatalog.model.DescribeProvisionedProductResponse
import aws.sdk.kotlin.services.servicecatalog.model.ProvisionedProductDetail
import aws.sdk.kotlin.services.servicecatalog.model.ServiceCatalogException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeProvisionedProductOperationDeserializer: HttpDeserialize<DescribeProvisionedProductResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeProvisionedProductResponse {
        if (!response.status.isSuccess()) {
            throwDescribeProvisionedProductError(context, response)
        }
        val builder = DescribeProvisionedProductResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeProvisionedProductOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeProvisionedProductError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceCatalogException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParametersException" -> InvalidParametersExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ServiceCatalogException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeProvisionedProductOperationBody(builder: DescribeProvisionedProductResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLOUDWATCHDASHBOARDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CloudWatchDashboards"))
    val PROVISIONEDPRODUCTDETAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ProvisionedProductDetail"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLOUDWATCHDASHBOARDS_DESCRIPTOR)
        field(PROVISIONEDPRODUCTDETAIL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLOUDWATCHDASHBOARDS_DESCRIPTOR.index -> builder.cloudWatchDashboards =
                    deserializer.deserializeList(CLOUDWATCHDASHBOARDS_DESCRIPTOR) {
                        val col0 = mutableListOf<CloudWatchDashboard>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCloudWatchDashboardDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PROVISIONEDPRODUCTDETAIL_DESCRIPTOR.index -> builder.provisionedProductDetail = deserializeProvisionedProductDetailDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
