// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.servicecatalog.model.DescribeProvisioningArtifactResponse
import aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactDetail
import aws.sdk.kotlin.services.servicecatalog.model.ServiceCatalogException
import aws.sdk.kotlin.services.servicecatalog.model.Status
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeProvisioningArtifactOperationDeserializer: HttpDeserialize<DescribeProvisioningArtifactResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeProvisioningArtifactResponse {
        if (!response.status.isSuccess()) {
            throwDescribeProvisioningArtifactError(context, response)
        }
        val builder = DescribeProvisioningArtifactResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeProvisioningArtifactOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeProvisioningArtifactError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceCatalogException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParametersException" -> InvalidParametersExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ServiceCatalogException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeProvisioningArtifactOperationBody(builder: DescribeProvisioningArtifactResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Info"))
    val PROVISIONINGARTIFACTDETAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ProvisioningArtifactDetail"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INFO_DESCRIPTOR)
        field(PROVISIONINGARTIFACTDETAIL_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INFO_DESCRIPTOR.index -> builder.info =
                    deserializer.deserializeMap(INFO_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                PROVISIONINGARTIFACTDETAIL_DESCRIPTOR.index -> builder.provisioningArtifactDetail = deserializeProvisioningArtifactDetailDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { Status.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
