// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.servicecatalog.model.ConstraintSummary
import aws.sdk.kotlin.services.servicecatalog.model.DescribeProvisioningParametersResponse
import aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactOutput
import aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactParameter
import aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactPreferences
import aws.sdk.kotlin.services.servicecatalog.model.ServiceCatalogException
import aws.sdk.kotlin.services.servicecatalog.model.TagOptionSummary
import aws.sdk.kotlin.services.servicecatalog.model.UsageInstruction
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeProvisioningParametersOperationDeserializer: HttpDeserialize<DescribeProvisioningParametersResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeProvisioningParametersResponse {
        if (!response.status.isSuccess()) {
            throwDescribeProvisioningParametersError(context, response)
        }
        val builder = DescribeProvisioningParametersResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeProvisioningParametersOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeProvisioningParametersError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceCatalogException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParametersException" -> InvalidParametersExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ServiceCatalogException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeProvisioningParametersOperationBody(builder: DescribeProvisioningParametersResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONSTRAINTSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ConstraintSummaries"))
    val PROVISIONINGARTIFACTOUTPUTKEYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProvisioningArtifactOutputKeys"))
    val PROVISIONINGARTIFACTOUTPUTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProvisioningArtifactOutputs"))
    val PROVISIONINGARTIFACTPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProvisioningArtifactParameters"))
    val PROVISIONINGARTIFACTPREFERENCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ProvisioningArtifactPreferences"))
    val TAGOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TagOptions"))
    val USAGEINSTRUCTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UsageInstructions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONSTRAINTSUMMARIES_DESCRIPTOR)
        field(PROVISIONINGARTIFACTOUTPUTKEYS_DESCRIPTOR)
        field(PROVISIONINGARTIFACTOUTPUTS_DESCRIPTOR)
        field(PROVISIONINGARTIFACTPARAMETERS_DESCRIPTOR)
        field(PROVISIONINGARTIFACTPREFERENCES_DESCRIPTOR)
        field(TAGOPTIONS_DESCRIPTOR)
        field(USAGEINSTRUCTIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONSTRAINTSUMMARIES_DESCRIPTOR.index -> builder.constraintSummaries =
                    deserializer.deserializeList(CONSTRAINTSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<ConstraintSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeConstraintSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PROVISIONINGARTIFACTOUTPUTKEYS_DESCRIPTOR.index -> builder.provisioningArtifactOutputKeys =
                    deserializer.deserializeList(PROVISIONINGARTIFACTOUTPUTKEYS_DESCRIPTOR) {
                        val col0 = mutableListOf<ProvisioningArtifactOutput>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProvisioningArtifactOutputDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PROVISIONINGARTIFACTOUTPUTS_DESCRIPTOR.index -> builder.provisioningArtifactOutputs =
                    deserializer.deserializeList(PROVISIONINGARTIFACTOUTPUTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ProvisioningArtifactOutput>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProvisioningArtifactOutputDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PROVISIONINGARTIFACTPARAMETERS_DESCRIPTOR.index -> builder.provisioningArtifactParameters =
                    deserializer.deserializeList(PROVISIONINGARTIFACTPARAMETERS_DESCRIPTOR) {
                        val col0 = mutableListOf<ProvisioningArtifactParameter>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProvisioningArtifactParameterDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PROVISIONINGARTIFACTPREFERENCES_DESCRIPTOR.index -> builder.provisioningArtifactPreferences = deserializeProvisioningArtifactPreferencesDocument(deserializer)
                TAGOPTIONS_DESCRIPTOR.index -> builder.tagOptions =
                    deserializer.deserializeList(TAGOPTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<TagOptionSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagOptionSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                USAGEINSTRUCTIONS_DESCRIPTOR.index -> builder.usageInstructions =
                    deserializer.deserializeList(USAGEINSTRUCTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<UsageInstruction>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUsageInstructionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
