// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.servicecatalog.model.EnableAwsOrganizationsAccessResponse
import aws.sdk.kotlin.services.servicecatalog.model.ServiceCatalogException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class EnableAWSOrganizationsAccessOperationDeserializer: HttpDeserialize<EnableAwsOrganizationsAccessResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): EnableAwsOrganizationsAccessResponse {
        if (!response.status.isSuccess()) {
            throwEnableAwsOrganizationsAccessError(context, response)
        }
        val builder = EnableAwsOrganizationsAccessResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwEnableAwsOrganizationsAccessError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceCatalogException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidStateException" -> InvalidStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "OperationNotSupportedException" -> OperationNotSupportedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ServiceCatalogException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
