// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.servicecatalog.model.ListProvisionedProductPlansResponse
import aws.sdk.kotlin.services.servicecatalog.model.ProvisionedProductPlanSummary
import aws.sdk.kotlin.services.servicecatalog.model.ServiceCatalogException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListProvisionedProductPlansOperationDeserializer: HttpDeserialize<ListProvisionedProductPlansResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListProvisionedProductPlansResponse {
        if (!response.status.isSuccess()) {
            throwListProvisionedProductPlansError(context, response)
        }
        val builder = ListProvisionedProductPlansResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListProvisionedProductPlansOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListProvisionedProductPlansError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceCatalogException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParametersException" -> InvalidParametersExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ServiceCatalogException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListProvisionedProductPlansOperationBody(builder: ListProvisionedProductPlansResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTPAGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextPageToken"))
    val PROVISIONEDPRODUCTPLANS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProvisionedProductPlans"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTPAGETOKEN_DESCRIPTOR)
        field(PROVISIONEDPRODUCTPLANS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTPAGETOKEN_DESCRIPTOR.index -> builder.nextPageToken = deserializeString()
                PROVISIONEDPRODUCTPLANS_DESCRIPTOR.index -> builder.provisionedProductPlans =
                    deserializer.deserializeList(PROVISIONEDPRODUCTPLANS_DESCRIPTOR) {
                        val col0 = mutableListOf<ProvisionedProductPlanSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProvisionedProductPlanSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
