// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.servicecatalog.model.ProductViewAggregationValue
import aws.sdk.kotlin.services.servicecatalog.model.ProductViewSummary
import aws.sdk.kotlin.services.servicecatalog.model.SearchProductsResponse
import aws.sdk.kotlin.services.servicecatalog.model.ServiceCatalogException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SearchProductsOperationDeserializer: HttpDeserialize<SearchProductsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): SearchProductsResponse {
        if (!response.status.isSuccess()) {
            throwSearchProductsError(context, response)
        }
        val builder = SearchProductsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeSearchProductsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwSearchProductsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceCatalogException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParametersException" -> InvalidParametersExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ServiceCatalogException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSearchProductsOperationBody(builder: SearchProductsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTPAGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextPageToken"))
    val PRODUCTVIEWAGGREGATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ProductViewAggregations"))
    val PRODUCTVIEWAGGREGATIONS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val PRODUCTVIEWSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProductViewSummaries"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTPAGETOKEN_DESCRIPTOR)
        field(PRODUCTVIEWAGGREGATIONS_DESCRIPTOR)
        field(PRODUCTVIEWSUMMARIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTPAGETOKEN_DESCRIPTOR.index -> builder.nextPageToken = deserializeString()
                PRODUCTVIEWAGGREGATIONS_DESCRIPTOR.index -> builder.productViewAggregations =
                    deserializer.deserializeMap(PRODUCTVIEWAGGREGATIONS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, List<ProductViewAggregationValue>>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 =
                                if (nextHasValue()) {
                                    deserializer.deserializeList(PRODUCTVIEWAGGREGATIONS_C0_DESCRIPTOR) {
                                        val col1 = mutableListOf<ProductViewAggregationValue>()
                                        while (hasNextElement()) {
                                            val el1 = if (nextHasValue()) { deserializeProductViewAggregationValueDocument(deserializer) } else { deserializeNull(); continue }
                                            col1.add(el1)
                                        }
                                        col1
                                    }
                                } else { deserializeNull(); continue }

                            map0[k0] = v0
                        }
                        map0
                    }
                PRODUCTVIEWSUMMARIES_DESCRIPTOR.index -> builder.productViewSummaries =
                    deserializer.deserializeList(PRODUCTVIEWSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<ProductViewSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProductViewSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
