// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.servicecatalog.model.RecordStatus
import aws.sdk.kotlin.services.servicecatalog.model.ServiceCatalogException
import aws.sdk.kotlin.services.servicecatalog.model.UpdateProvisionedProductPropertiesResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateProvisionedProductPropertiesOperationDeserializer: HttpDeserialize<UpdateProvisionedProductPropertiesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateProvisionedProductPropertiesResponse {
        if (!response.status.isSuccess()) {
            throwUpdateProvisionedProductPropertiesError(context, response)
        }
        val builder = UpdateProvisionedProductPropertiesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateProvisionedProductPropertiesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateProvisionedProductPropertiesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceCatalogException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParametersException" -> InvalidParametersExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidStateException" -> InvalidStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ServiceCatalogException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateProvisionedProductPropertiesOperationBody(builder: UpdateProvisionedProductPropertiesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PROVISIONEDPRODUCTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProvisionedProductId"))
    val PROVISIONEDPRODUCTPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ProvisionedProductProperties"))
    val RECORDID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RecordId"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PROVISIONEDPRODUCTID_DESCRIPTOR)
        field(PROVISIONEDPRODUCTPROPERTIES_DESCRIPTOR)
        field(RECORDID_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PROVISIONEDPRODUCTID_DESCRIPTOR.index -> builder.provisionedProductId = deserializeString()
                PROVISIONEDPRODUCTPROPERTIES_DESCRIPTOR.index -> builder.provisionedProductProperties =
                    deserializer.deserializeMap(PROVISIONEDPRODUCTPROPERTIES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                RECORDID_DESCRIPTOR.index -> builder.recordId = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { RecordStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
