// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.sesv2.model.*
import aws.sdk.kotlin.services.sesv2.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "SESv2"
public const val ServiceApiVersion: String = "2019-09-27"
public const val SdkVersion: String = "0.17.3-beta"

internal class DefaultSesV2Client(override val config: SesV2Client.Config) : SesV2Client {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Create a configuration set. *Configuration sets* are groups of rules that you can apply to the emails that you send. You apply a configuration set to an email by specifying the name of the configuration set when you call the Amazon SES API v2. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     */
    override suspend fun createConfigurationSet(input: CreateConfigurationSetRequest): CreateConfigurationSetResponse {
        val op = SdkHttpOperation.build<CreateConfigurationSetRequest, CreateConfigurationSetResponse> {
            serializer = CreateConfigurationSetOperationSerializer()
            deserializer = CreateConfigurationSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateConfigurationSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create an event destination. *Events* include message sends, deliveries, opens, clicks, bounces, and complaints. *Event destinations* are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
     *
     * A single configuration set can include more than one event destination.
     */
    override suspend fun createConfigurationSetEventDestination(input: CreateConfigurationSetEventDestinationRequest): CreateConfigurationSetEventDestinationResponse {
        val op = SdkHttpOperation.build<CreateConfigurationSetEventDestinationRequest, CreateConfigurationSetEventDestinationResponse> {
            serializer = CreateConfigurationSetEventDestinationOperationSerializer()
            deserializer = CreateConfigurationSetEventDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateConfigurationSetEventDestination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a contact, which is an end-user who is receiving the email, and adds them to a contact list.
     */
    override suspend fun createContact(input: CreateContactRequest): CreateContactResponse {
        val op = SdkHttpOperation.build<CreateContactRequest, CreateContactResponse> {
            serializer = CreateContactOperationSerializer()
            deserializer = CreateContactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateContact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a contact list.
     */
    override suspend fun createContactList(input: CreateContactListRequest): CreateContactListResponse {
        val op = SdkHttpOperation.build<CreateContactListRequest, CreateContactListResponse> {
            serializer = CreateContactListOperationSerializer()
            deserializer = CreateContactListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateContactList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new custom verification email template.
     *
     * For more information about custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html) in the *Amazon SES Developer Guide*.
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun createCustomVerificationEmailTemplate(input: CreateCustomVerificationEmailTemplateRequest): CreateCustomVerificationEmailTemplateResponse {
        val op = SdkHttpOperation.build<CreateCustomVerificationEmailTemplateRequest, CreateCustomVerificationEmailTemplateResponse> {
            serializer = CreateCustomVerificationEmailTemplateOperationSerializer()
            deserializer = CreateCustomVerificationEmailTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCustomVerificationEmailTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a new pool of dedicated IP addresses. A pool can include one or more dedicated IP addresses that are associated with your Amazon Web Services account. You can associate a pool with a configuration set. When you send an email that uses that configuration set, the message is sent from one of the addresses in the associated pool.
     */
    override suspend fun createDedicatedIpPool(input: CreateDedicatedIpPoolRequest): CreateDedicatedIpPoolResponse {
        val op = SdkHttpOperation.build<CreateDedicatedIpPoolRequest, CreateDedicatedIpPoolResponse> {
            serializer = CreateDedicatedIpPoolOperationSerializer()
            deserializer = CreateDedicatedIpPoolOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDedicatedIpPool"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a new predictive inbox placement test. Predictive inbox placement tests can help you predict how your messages will be handled by various email providers around the world. When you perform a predictive inbox placement test, you provide a sample message that contains the content that you plan to send to your customers. Amazon SES then sends that message to special email addresses spread across several major email providers. After about 24 hours, the test is complete, and you can use the `GetDeliverabilityTestReport` operation to view the results of the test.
     */
    override suspend fun createDeliverabilityTestReport(input: CreateDeliverabilityTestReportRequest): CreateDeliverabilityTestReportResponse {
        val op = SdkHttpOperation.build<CreateDeliverabilityTestReportRequest, CreateDeliverabilityTestReportResponse> {
            serializer = CreateDeliverabilityTestReportOperationSerializer()
            deserializer = CreateDeliverabilityTestReportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDeliverabilityTestReport"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts the process of verifying an email identity. An *identity* is an email address or domain that you use when you send email. Before you can use an identity to send email, you first have to verify it. By verifying an identity, you demonstrate that you're the owner of the identity, and that you've given Amazon SES API v2 permission to send email from the identity.
     *
     * When you verify an email address, Amazon SES sends an email to the address. Your email address is verified as soon as you follow the link in the verification email.
     *
     * When you verify a domain without specifying the `DkimSigningAttributes` object, this operation provides a set of DKIM tokens. You can convert these tokens into CNAME records, which you then add to the DNS configuration for your domain. Your domain is verified when Amazon SES detects these records in the DNS configuration for your domain. This verification method is known as [Easy DKIM](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
     *
     * Alternatively, you can perform the verification process by providing your own public-private key pair. This verification method is known as Bring Your Own DKIM (BYODKIM). To use BYODKIM, your call to the `CreateEmailIdentity` operation has to include the `DkimSigningAttributes` object. When you specify this object, you provide a selector (a component of the DNS record name that identifies the public key to use for DKIM authentication) and a private key.
     *
     * When you verify a domain, this operation provides a set of DKIM tokens, which you can convert into CNAME tokens. You add these CNAME tokens to the DNS configuration for your domain. Your domain is verified when Amazon SES detects these records in the DNS configuration for your domain. For some DNS providers, it can take 72 hours or more to complete the domain verification process.
     *
     * Additionally, you can associate an existing configuration set with the email identity that you're verifying.
     */
    override suspend fun createEmailIdentity(input: CreateEmailIdentityRequest): CreateEmailIdentityResponse {
        val op = SdkHttpOperation.build<CreateEmailIdentityRequest, CreateEmailIdentityResponse> {
            serializer = CreateEmailIdentityOperationSerializer()
            deserializer = CreateEmailIdentityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEmailIdentity"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates the specified sending authorization policy for the given identity (an email address or a domain).
     *
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     *
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun createEmailIdentityPolicy(input: CreateEmailIdentityPolicyRequest): CreateEmailIdentityPolicyResponse {
        val op = SdkHttpOperation.build<CreateEmailIdentityPolicyRequest, CreateEmailIdentityPolicyResponse> {
            serializer = CreateEmailIdentityPolicyOperationSerializer()
            deserializer = CreateEmailIdentityPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEmailIdentityPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an email template. Email templates enable you to send personalized email to one or more destinations in a single API operation. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html).
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun createEmailTemplate(input: CreateEmailTemplateRequest): CreateEmailTemplateResponse {
        val op = SdkHttpOperation.build<CreateEmailTemplateRequest, CreateEmailTemplateResponse> {
            serializer = CreateEmailTemplateOperationSerializer()
            deserializer = CreateEmailTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEmailTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an import job for a data destination.
     */
    override suspend fun createImportJob(input: CreateImportJobRequest): CreateImportJobResponse {
        val op = SdkHttpOperation.build<CreateImportJobRequest, CreateImportJobResponse> {
            serializer = CreateImportJobOperationSerializer()
            deserializer = CreateImportJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateImportJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete an existing configuration set.
     *
     * *Configuration sets* are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     */
    override suspend fun deleteConfigurationSet(input: DeleteConfigurationSetRequest): DeleteConfigurationSetResponse {
        val op = SdkHttpOperation.build<DeleteConfigurationSetRequest, DeleteConfigurationSetResponse> {
            serializer = DeleteConfigurationSetOperationSerializer()
            deserializer = DeleteConfigurationSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteConfigurationSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete an event destination.
     *
     * *Events* include message sends, deliveries, opens, clicks, bounces, and complaints. *Event destinations* are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
     */
    override suspend fun deleteConfigurationSetEventDestination(input: DeleteConfigurationSetEventDestinationRequest): DeleteConfigurationSetEventDestinationResponse {
        val op = SdkHttpOperation.build<DeleteConfigurationSetEventDestinationRequest, DeleteConfigurationSetEventDestinationResponse> {
            serializer = DeleteConfigurationSetEventDestinationOperationSerializer()
            deserializer = DeleteConfigurationSetEventDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteConfigurationSetEventDestination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a contact from a contact list.
     */
    override suspend fun deleteContact(input: DeleteContactRequest): DeleteContactResponse {
        val op = SdkHttpOperation.build<DeleteContactRequest, DeleteContactResponse> {
            serializer = DeleteContactOperationSerializer()
            deserializer = DeleteContactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteContact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a contact list and all of the contacts on that list.
     */
    override suspend fun deleteContactList(input: DeleteContactListRequest): DeleteContactListResponse {
        val op = SdkHttpOperation.build<DeleteContactListRequest, DeleteContactListResponse> {
            serializer = DeleteContactListOperationSerializer()
            deserializer = DeleteContactListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteContactList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing custom verification email template.
     *
     * For more information about custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html) in the *Amazon SES Developer Guide*.
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun deleteCustomVerificationEmailTemplate(input: DeleteCustomVerificationEmailTemplateRequest): DeleteCustomVerificationEmailTemplateResponse {
        val op = SdkHttpOperation.build<DeleteCustomVerificationEmailTemplateRequest, DeleteCustomVerificationEmailTemplateResponse> {
            serializer = DeleteCustomVerificationEmailTemplateOperationSerializer()
            deserializer = DeleteCustomVerificationEmailTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCustomVerificationEmailTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Delete a dedicated IP pool.
     */
    override suspend fun deleteDedicatedIpPool(input: DeleteDedicatedIpPoolRequest): DeleteDedicatedIpPoolResponse {
        val op = SdkHttpOperation.build<DeleteDedicatedIpPoolRequest, DeleteDedicatedIpPoolResponse> {
            serializer = DeleteDedicatedIpPoolOperationSerializer()
            deserializer = DeleteDedicatedIpPoolOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDedicatedIpPool"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an email identity. An identity can be either an email address or a domain name.
     */
    override suspend fun deleteEmailIdentity(input: DeleteEmailIdentityRequest): DeleteEmailIdentityResponse {
        val op = SdkHttpOperation.build<DeleteEmailIdentityRequest, DeleteEmailIdentityResponse> {
            serializer = DeleteEmailIdentityOperationSerializer()
            deserializer = DeleteEmailIdentityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEmailIdentity"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified sending authorization policy for the given identity (an email address or a domain). This API returns successfully even if a policy with the specified name does not exist.
     *
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     *
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun deleteEmailIdentityPolicy(input: DeleteEmailIdentityPolicyRequest): DeleteEmailIdentityPolicyResponse {
        val op = SdkHttpOperation.build<DeleteEmailIdentityPolicyRequest, DeleteEmailIdentityPolicyResponse> {
            serializer = DeleteEmailIdentityPolicyOperationSerializer()
            deserializer = DeleteEmailIdentityPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEmailIdentityPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an email template.
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun deleteEmailTemplate(input: DeleteEmailTemplateRequest): DeleteEmailTemplateResponse {
        val op = SdkHttpOperation.build<DeleteEmailTemplateRequest, DeleteEmailTemplateResponse> {
            serializer = DeleteEmailTemplateOperationSerializer()
            deserializer = DeleteEmailTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEmailTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes an email address from the suppression list for your account.
     */
    override suspend fun deleteSuppressedDestination(input: DeleteSuppressedDestinationRequest): DeleteSuppressedDestinationResponse {
        val op = SdkHttpOperation.build<DeleteSuppressedDestinationRequest, DeleteSuppressedDestinationResponse> {
            serializer = DeleteSuppressedDestinationOperationSerializer()
            deserializer = DeleteSuppressedDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSuppressedDestination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Obtain information about the email-sending status and capabilities of your Amazon SES account in the current Amazon Web Services Region.
     */
    override suspend fun getAccount(input: GetAccountRequest): GetAccountResponse {
        val op = SdkHttpOperation.build<GetAccountRequest, GetAccountResponse> {
            serializer = GetAccountOperationSerializer()
            deserializer = GetAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve a list of the blacklists that your dedicated IP addresses appear on.
     */
    override suspend fun getBlacklistReports(input: GetBlacklistReportsRequest): GetBlacklistReportsResponse {
        val op = SdkHttpOperation.build<GetBlacklistReportsRequest, GetBlacklistReportsResponse> {
            serializer = GetBlacklistReportsOperationSerializer()
            deserializer = GetBlacklistReportsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBlacklistReports"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get information about an existing configuration set, including the dedicated IP pool that it's associated with, whether or not it's enabled for sending email, and more.
     *
     * *Configuration sets* are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     */
    override suspend fun getConfigurationSet(input: GetConfigurationSetRequest): GetConfigurationSetResponse {
        val op = SdkHttpOperation.build<GetConfigurationSetRequest, GetConfigurationSetResponse> {
            serializer = GetConfigurationSetOperationSerializer()
            deserializer = GetConfigurationSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetConfigurationSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve a list of event destinations that are associated with a configuration set.
     *
     * *Events* include message sends, deliveries, opens, clicks, bounces, and complaints. *Event destinations* are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
     */
    override suspend fun getConfigurationSetEventDestinations(input: GetConfigurationSetEventDestinationsRequest): GetConfigurationSetEventDestinationsResponse {
        val op = SdkHttpOperation.build<GetConfigurationSetEventDestinationsRequest, GetConfigurationSetEventDestinationsResponse> {
            serializer = GetConfigurationSetEventDestinationsOperationSerializer()
            deserializer = GetConfigurationSetEventDestinationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetConfigurationSetEventDestinations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a contact from a contact list.
     */
    override suspend fun getContact(input: GetContactRequest): GetContactResponse {
        val op = SdkHttpOperation.build<GetContactRequest, GetContactResponse> {
            serializer = GetContactOperationSerializer()
            deserializer = GetContactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetContact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns contact list metadata. It does not return any information about the contacts present in the list.
     */
    override suspend fun getContactList(input: GetContactListRequest): GetContactListResponse {
        val op = SdkHttpOperation.build<GetContactListRequest, GetContactListResponse> {
            serializer = GetContactListOperationSerializer()
            deserializer = GetContactListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetContactList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the custom email verification template for the template name you specify.
     *
     * For more information about custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html) in the *Amazon SES Developer Guide*.
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun getCustomVerificationEmailTemplate(input: GetCustomVerificationEmailTemplateRequest): GetCustomVerificationEmailTemplateResponse {
        val op = SdkHttpOperation.build<GetCustomVerificationEmailTemplateRequest, GetCustomVerificationEmailTemplateResponse> {
            serializer = GetCustomVerificationEmailTemplateOperationSerializer()
            deserializer = GetCustomVerificationEmailTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCustomVerificationEmailTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get information about a dedicated IP address, including the name of the dedicated IP pool that it's associated with, as well information about the automatic warm-up process for the address.
     */
    override suspend fun getDedicatedIp(input: GetDedicatedIpRequest): GetDedicatedIpResponse {
        val op = SdkHttpOperation.build<GetDedicatedIpRequest, GetDedicatedIpResponse> {
            serializer = GetDedicatedIpOperationSerializer()
            deserializer = GetDedicatedIpOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDedicatedIp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the dedicated IP addresses that are associated with your Amazon Web Services account.
     */
    override suspend fun getDedicatedIps(input: GetDedicatedIpsRequest): GetDedicatedIpsResponse {
        val op = SdkHttpOperation.build<GetDedicatedIpsRequest, GetDedicatedIpsResponse> {
            serializer = GetDedicatedIpsOperationSerializer()
            deserializer = GetDedicatedIpsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDedicatedIps"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve information about the status of the Deliverability dashboard for your account. When the Deliverability dashboard is enabled, you gain access to reputation, deliverability, and other metrics for the domains that you use to send email. You also gain the ability to perform predictive inbox placement tests.
     *
     * When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees that you accrue by using Amazon SES and other Amazon Web Services services. For more information about the features and cost of a Deliverability dashboard subscription, see [Amazon SES Pricing](http://aws.amazon.com/ses/pricing/).
     */
    override suspend fun getDeliverabilityDashboardOptions(input: GetDeliverabilityDashboardOptionsRequest): GetDeliverabilityDashboardOptionsResponse {
        val op = SdkHttpOperation.build<GetDeliverabilityDashboardOptionsRequest, GetDeliverabilityDashboardOptionsResponse> {
            serializer = GetDeliverabilityDashboardOptionsOperationSerializer()
            deserializer = GetDeliverabilityDashboardOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDeliverabilityDashboardOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve the results of a predictive inbox placement test.
     */
    override suspend fun getDeliverabilityTestReport(input: GetDeliverabilityTestReportRequest): GetDeliverabilityTestReportResponse {
        val op = SdkHttpOperation.build<GetDeliverabilityTestReportRequest, GetDeliverabilityTestReportResponse> {
            serializer = GetDeliverabilityTestReportOperationSerializer()
            deserializer = GetDeliverabilityTestReportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDeliverabilityTestReport"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve all the deliverability data for a specific campaign. This data is available for a campaign only if the campaign sent email by using a domain that the Deliverability dashboard is enabled for.
     */
    override suspend fun getDomainDeliverabilityCampaign(input: GetDomainDeliverabilityCampaignRequest): GetDomainDeliverabilityCampaignResponse {
        val op = SdkHttpOperation.build<GetDomainDeliverabilityCampaignRequest, GetDomainDeliverabilityCampaignResponse> {
            serializer = GetDomainDeliverabilityCampaignOperationSerializer()
            deserializer = GetDomainDeliverabilityCampaignOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDomainDeliverabilityCampaign"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve inbox placement and engagement rates for the domains that you use to send email.
     */
    override suspend fun getDomainStatisticsReport(input: GetDomainStatisticsReportRequest): GetDomainStatisticsReportResponse {
        val op = SdkHttpOperation.build<GetDomainStatisticsReportRequest, GetDomainStatisticsReportResponse> {
            serializer = GetDomainStatisticsReportOperationSerializer()
            deserializer = GetDomainStatisticsReportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDomainStatisticsReport"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides information about a specific identity, including the identity's verification status, sending authorization policies, its DKIM authentication status, and its custom Mail-From settings.
     */
    override suspend fun getEmailIdentity(input: GetEmailIdentityRequest): GetEmailIdentityResponse {
        val op = SdkHttpOperation.build<GetEmailIdentityRequest, GetEmailIdentityResponse> {
            serializer = GetEmailIdentityOperationSerializer()
            deserializer = GetEmailIdentityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEmailIdentity"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the requested sending authorization policies for the given identity (an email address or a domain). The policies are returned as a map of policy names to policy contents. You can retrieve a maximum of 20 policies at a time.
     *
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     *
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun getEmailIdentityPolicies(input: GetEmailIdentityPoliciesRequest): GetEmailIdentityPoliciesResponse {
        val op = SdkHttpOperation.build<GetEmailIdentityPoliciesRequest, GetEmailIdentityPoliciesResponse> {
            serializer = GetEmailIdentityPoliciesOperationSerializer()
            deserializer = GetEmailIdentityPoliciesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEmailIdentityPolicies"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Displays the template object (which includes the subject line, HTML part and text part) for the template you specify.
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun getEmailTemplate(input: GetEmailTemplateRequest): GetEmailTemplateResponse {
        val op = SdkHttpOperation.build<GetEmailTemplateRequest, GetEmailTemplateResponse> {
            serializer = GetEmailTemplateOperationSerializer()
            deserializer = GetEmailTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEmailTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides information about an import job.
     */
    override suspend fun getImportJob(input: GetImportJobRequest): GetImportJobResponse {
        val op = SdkHttpOperation.build<GetImportJobRequest, GetImportJobResponse> {
            serializer = GetImportJobOperationSerializer()
            deserializer = GetImportJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetImportJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about a specific email address that's on the suppression list for your account.
     */
    override suspend fun getSuppressedDestination(input: GetSuppressedDestinationRequest): GetSuppressedDestinationResponse {
        val op = SdkHttpOperation.build<GetSuppressedDestinationRequest, GetSuppressedDestinationResponse> {
            serializer = GetSuppressedDestinationOperationSerializer()
            deserializer = GetSuppressedDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSuppressedDestination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List all of the configuration sets associated with your account in the current region.
     *
     * *Configuration sets* are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     */
    override suspend fun listConfigurationSets(input: ListConfigurationSetsRequest): ListConfigurationSetsResponse {
        val op = SdkHttpOperation.build<ListConfigurationSetsRequest, ListConfigurationSetsResponse> {
            serializer = ListConfigurationSetsOperationSerializer()
            deserializer = ListConfigurationSetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListConfigurationSets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all of the contact lists available.
     */
    override suspend fun listContactLists(input: ListContactListsRequest): ListContactListsResponse {
        val op = SdkHttpOperation.build<ListContactListsRequest, ListContactListsResponse> {
            serializer = ListContactListsOperationSerializer()
            deserializer = ListContactListsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListContactLists"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the contacts present in a specific contact list.
     */
    override suspend fun listContacts(input: ListContactsRequest): ListContactsResponse {
        val op = SdkHttpOperation.build<ListContactsRequest, ListContactsResponse> {
            serializer = ListContactsOperationSerializer()
            deserializer = ListContactsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListContacts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the existing custom verification email templates for your account in the current Amazon Web Services Region.
     *
     * For more information about custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html) in the *Amazon SES Developer Guide*.
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun listCustomVerificationEmailTemplates(input: ListCustomVerificationEmailTemplatesRequest): ListCustomVerificationEmailTemplatesResponse {
        val op = SdkHttpOperation.build<ListCustomVerificationEmailTemplatesRequest, ListCustomVerificationEmailTemplatesResponse> {
            serializer = ListCustomVerificationEmailTemplatesOperationSerializer()
            deserializer = ListCustomVerificationEmailTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCustomVerificationEmailTemplates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List all of the dedicated IP pools that exist in your Amazon Web Services account in the current Region.
     */
    override suspend fun listDedicatedIpPools(input: ListDedicatedIpPoolsRequest): ListDedicatedIpPoolsResponse {
        val op = SdkHttpOperation.build<ListDedicatedIpPoolsRequest, ListDedicatedIpPoolsResponse> {
            serializer = ListDedicatedIpPoolsOperationSerializer()
            deserializer = ListDedicatedIpPoolsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDedicatedIpPools"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Show a list of the predictive inbox placement tests that you've performed, regardless of their statuses. For predictive inbox placement tests that are complete, you can use the `GetDeliverabilityTestReport` operation to view the results.
     */
    override suspend fun listDeliverabilityTestReports(input: ListDeliverabilityTestReportsRequest): ListDeliverabilityTestReportsResponse {
        val op = SdkHttpOperation.build<ListDeliverabilityTestReportsRequest, ListDeliverabilityTestReportsResponse> {
            serializer = ListDeliverabilityTestReportsOperationSerializer()
            deserializer = ListDeliverabilityTestReportsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDeliverabilityTestReports"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified time range. This data is available for a domain only if you enabled the Deliverability dashboard for the domain.
     */
    override suspend fun listDomainDeliverabilityCampaigns(input: ListDomainDeliverabilityCampaignsRequest): ListDomainDeliverabilityCampaignsResponse {
        val op = SdkHttpOperation.build<ListDomainDeliverabilityCampaignsRequest, ListDomainDeliverabilityCampaignsResponse> {
            serializer = ListDomainDeliverabilityCampaignsOperationSerializer()
            deserializer = ListDomainDeliverabilityCampaignsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDomainDeliverabilityCampaigns"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all of the email identities that are associated with your Amazon Web Services account. An identity can be either an email address or a domain. This operation returns identities that are verified as well as those that aren't. This operation returns identities that are associated with Amazon SES and Amazon Pinpoint.
     */
    override suspend fun listEmailIdentities(input: ListEmailIdentitiesRequest): ListEmailIdentitiesResponse {
        val op = SdkHttpOperation.build<ListEmailIdentitiesRequest, ListEmailIdentitiesResponse> {
            serializer = ListEmailIdentitiesOperationSerializer()
            deserializer = ListEmailIdentitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEmailIdentities"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the email templates present in your Amazon SES account in the current Amazon Web Services Region.
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun listEmailTemplates(input: ListEmailTemplatesRequest): ListEmailTemplatesResponse {
        val op = SdkHttpOperation.build<ListEmailTemplatesRequest, ListEmailTemplatesResponse> {
            serializer = ListEmailTemplatesOperationSerializer()
            deserializer = ListEmailTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEmailTemplates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all of the import jobs.
     */
    override suspend fun listImportJobs(input: ListImportJobsRequest): ListImportJobsResponse {
        val op = SdkHttpOperation.build<ListImportJobsRequest, ListImportJobsResponse> {
            serializer = ListImportJobsOperationSerializer()
            deserializer = ListImportJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListImportJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of email addresses that are on the suppression list for your account.
     */
    override suspend fun listSuppressedDestinations(input: ListSuppressedDestinationsRequest): ListSuppressedDestinationsResponse {
        val op = SdkHttpOperation.build<ListSuppressedDestinationsRequest, ListSuppressedDestinationsResponse> {
            serializer = ListSuppressedDestinationsOperationSerializer()
            deserializer = ListSuppressedDestinationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSuppressedDestinations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve a list of the tags (keys and values) that are associated with a specified resource. A *tag* is a label that you optionally define and associate with a resource. Each tag consists of a required *tag key* and an optional associated *tag value*. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enable or disable the automatic warm-up feature for dedicated IP addresses.
     */
    override suspend fun putAccountDedicatedIpWarmupAttributes(input: PutAccountDedicatedIpWarmupAttributesRequest): PutAccountDedicatedIpWarmupAttributesResponse {
        val op = SdkHttpOperation.build<PutAccountDedicatedIpWarmupAttributesRequest, PutAccountDedicatedIpWarmupAttributesResponse> {
            serializer = PutAccountDedicatedIpWarmupAttributesOperationSerializer()
            deserializer = PutAccountDedicatedIpWarmupAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutAccountDedicatedIpWarmupAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update your Amazon SES account details.
     */
    override suspend fun putAccountDetails(input: PutAccountDetailsRequest): PutAccountDetailsResponse {
        val op = SdkHttpOperation.build<PutAccountDetailsRequest, PutAccountDetailsResponse> {
            serializer = PutAccountDetailsOperationSerializer()
            deserializer = PutAccountDetailsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutAccountDetails"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enable or disable the ability of your account to send email.
     */
    override suspend fun putAccountSendingAttributes(input: PutAccountSendingAttributesRequest): PutAccountSendingAttributesResponse {
        val op = SdkHttpOperation.build<PutAccountSendingAttributesRequest, PutAccountSendingAttributesResponse> {
            serializer = PutAccountSendingAttributesOperationSerializer()
            deserializer = PutAccountSendingAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutAccountSendingAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Change the settings for the account-level suppression list.
     */
    override suspend fun putAccountSuppressionAttributes(input: PutAccountSuppressionAttributesRequest): PutAccountSuppressionAttributesResponse {
        val op = SdkHttpOperation.build<PutAccountSuppressionAttributesRequest, PutAccountSuppressionAttributesResponse> {
            serializer = PutAccountSuppressionAttributesOperationSerializer()
            deserializer = PutAccountSuppressionAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutAccountSuppressionAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associate a configuration set with a dedicated IP pool. You can use dedicated IP pools to create groups of dedicated IP addresses for sending specific types of email.
     */
    override suspend fun putConfigurationSetDeliveryOptions(input: PutConfigurationSetDeliveryOptionsRequest): PutConfigurationSetDeliveryOptionsResponse {
        val op = SdkHttpOperation.build<PutConfigurationSetDeliveryOptionsRequest, PutConfigurationSetDeliveryOptionsResponse> {
            serializer = PutConfigurationSetDeliveryOptionsOperationSerializer()
            deserializer = PutConfigurationSetDeliveryOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutConfigurationSetDeliveryOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enable or disable collection of reputation metrics for emails that you send using a particular configuration set in a specific Amazon Web Services Region.
     */
    override suspend fun putConfigurationSetReputationOptions(input: PutConfigurationSetReputationOptionsRequest): PutConfigurationSetReputationOptionsResponse {
        val op = SdkHttpOperation.build<PutConfigurationSetReputationOptionsRequest, PutConfigurationSetReputationOptionsResponse> {
            serializer = PutConfigurationSetReputationOptionsOperationSerializer()
            deserializer = PutConfigurationSetReputationOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutConfigurationSetReputationOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enable or disable email sending for messages that use a particular configuration set in a specific Amazon Web Services Region.
     */
    override suspend fun putConfigurationSetSendingOptions(input: PutConfigurationSetSendingOptionsRequest): PutConfigurationSetSendingOptionsResponse {
        val op = SdkHttpOperation.build<PutConfigurationSetSendingOptionsRequest, PutConfigurationSetSendingOptionsResponse> {
            serializer = PutConfigurationSetSendingOptionsOperationSerializer()
            deserializer = PutConfigurationSetSendingOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutConfigurationSetSendingOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Specify the account suppression list preferences for a configuration set.
     */
    override suspend fun putConfigurationSetSuppressionOptions(input: PutConfigurationSetSuppressionOptionsRequest): PutConfigurationSetSuppressionOptionsResponse {
        val op = SdkHttpOperation.build<PutConfigurationSetSuppressionOptionsRequest, PutConfigurationSetSuppressionOptionsResponse> {
            serializer = PutConfigurationSetSuppressionOptionsOperationSerializer()
            deserializer = PutConfigurationSetSuppressionOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutConfigurationSetSuppressionOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Specify a custom domain to use for open and click tracking elements in email that you send.
     */
    override suspend fun putConfigurationSetTrackingOptions(input: PutConfigurationSetTrackingOptionsRequest): PutConfigurationSetTrackingOptionsResponse {
        val op = SdkHttpOperation.build<PutConfigurationSetTrackingOptionsRequest, PutConfigurationSetTrackingOptionsResponse> {
            serializer = PutConfigurationSetTrackingOptionsOperationSerializer()
            deserializer = PutConfigurationSetTrackingOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutConfigurationSetTrackingOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Move a dedicated IP address to an existing dedicated IP pool.
     *
     * The dedicated IP address that you specify must already exist, and must be associated with your Amazon Web Services account.
     *
     * The dedicated IP pool you specify must already exist. You can create a new pool by using the `CreateDedicatedIpPool` operation.
     */
    override suspend fun putDedicatedIpInPool(input: PutDedicatedIpInPoolRequest): PutDedicatedIpInPoolResponse {
        val op = SdkHttpOperation.build<PutDedicatedIpInPoolRequest, PutDedicatedIpInPoolResponse> {
            serializer = PutDedicatedIpInPoolOperationSerializer()
            deserializer = PutDedicatedIpInPoolOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutDedicatedIpInPool"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     *
     */
    override suspend fun putDedicatedIpWarmupAttributes(input: PutDedicatedIpWarmupAttributesRequest): PutDedicatedIpWarmupAttributesResponse {
        val op = SdkHttpOperation.build<PutDedicatedIpWarmupAttributesRequest, PutDedicatedIpWarmupAttributesResponse> {
            serializer = PutDedicatedIpWarmupAttributesOperationSerializer()
            deserializer = PutDedicatedIpWarmupAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutDedicatedIpWarmupAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enable or disable the Deliverability dashboard. When you enable the Deliverability dashboard, you gain access to reputation, deliverability, and other metrics for the domains that you use to send email. You also gain the ability to perform predictive inbox placement tests.
     *
     * When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees that you accrue by using Amazon SES and other Amazon Web Services services. For more information about the features and cost of a Deliverability dashboard subscription, see [Amazon SES Pricing](http://aws.amazon.com/ses/pricing/).
     */
    override suspend fun putDeliverabilityDashboardOption(input: PutDeliverabilityDashboardOptionRequest): PutDeliverabilityDashboardOptionResponse {
        val op = SdkHttpOperation.build<PutDeliverabilityDashboardOptionRequest, PutDeliverabilityDashboardOptionResponse> {
            serializer = PutDeliverabilityDashboardOptionOperationSerializer()
            deserializer = PutDeliverabilityDashboardOptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutDeliverabilityDashboardOption"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Used to associate a configuration set with an email identity.
     */
    override suspend fun putEmailIdentityConfigurationSetAttributes(input: PutEmailIdentityConfigurationSetAttributesRequest): PutEmailIdentityConfigurationSetAttributesResponse {
        val op = SdkHttpOperation.build<PutEmailIdentityConfigurationSetAttributesRequest, PutEmailIdentityConfigurationSetAttributesResponse> {
            serializer = PutEmailIdentityConfigurationSetAttributesOperationSerializer()
            deserializer = PutEmailIdentityConfigurationSetAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutEmailIdentityConfigurationSetAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Used to enable or disable DKIM authentication for an email identity.
     */
    override suspend fun putEmailIdentityDkimAttributes(input: PutEmailIdentityDkimAttributesRequest): PutEmailIdentityDkimAttributesResponse {
        val op = SdkHttpOperation.build<PutEmailIdentityDkimAttributesRequest, PutEmailIdentityDkimAttributesResponse> {
            serializer = PutEmailIdentityDkimAttributesOperationSerializer()
            deserializer = PutEmailIdentityDkimAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutEmailIdentityDkimAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Used to configure or change the DKIM authentication settings for an email domain identity. You can use this operation to do any of the following:
     * + Update the signing attributes for an identity that uses Bring Your Own DKIM (BYODKIM).
     * + Update the key length that should be used for Easy DKIM.
     * + Change from using no DKIM authentication to using Easy DKIM.
     * + Change from using no DKIM authentication to using BYODKIM.
     * + Change from using Easy DKIM to using BYODKIM.
     * + Change from using BYODKIM to using Easy DKIM.
     */
    override suspend fun putEmailIdentityDkimSigningAttributes(input: PutEmailIdentityDkimSigningAttributesRequest): PutEmailIdentityDkimSigningAttributesResponse {
        val op = SdkHttpOperation.build<PutEmailIdentityDkimSigningAttributesRequest, PutEmailIdentityDkimSigningAttributesResponse> {
            serializer = PutEmailIdentityDkimSigningAttributesOperationSerializer()
            deserializer = PutEmailIdentityDkimSigningAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutEmailIdentityDkimSigningAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Used to enable or disable feedback forwarding for an identity. This setting determines what happens when an identity is used to send an email that results in a bounce or complaint event.
     *
     * If the value is `true`, you receive email notifications when bounce or complaint events occur. These notifications are sent to the address that you specified in the `Return-Path` header of the original email.
     *
     * You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an email notification when these events occur (even if this setting is disabled).
     */
    override suspend fun putEmailIdentityFeedbackAttributes(input: PutEmailIdentityFeedbackAttributesRequest): PutEmailIdentityFeedbackAttributesResponse {
        val op = SdkHttpOperation.build<PutEmailIdentityFeedbackAttributesRequest, PutEmailIdentityFeedbackAttributesResponse> {
            serializer = PutEmailIdentityFeedbackAttributesOperationSerializer()
            deserializer = PutEmailIdentityFeedbackAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutEmailIdentityFeedbackAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Used to enable or disable the custom Mail-From domain configuration for an email identity.
     */
    override suspend fun putEmailIdentityMailFromAttributes(input: PutEmailIdentityMailFromAttributesRequest): PutEmailIdentityMailFromAttributesResponse {
        val op = SdkHttpOperation.build<PutEmailIdentityMailFromAttributesRequest, PutEmailIdentityMailFromAttributesResponse> {
            serializer = PutEmailIdentityMailFromAttributesOperationSerializer()
            deserializer = PutEmailIdentityMailFromAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutEmailIdentityMailFromAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds an email address to the suppression list for your account.
     */
    override suspend fun putSuppressedDestination(input: PutSuppressedDestinationRequest): PutSuppressedDestinationResponse {
        val op = SdkHttpOperation.build<PutSuppressedDestinationRequest, PutSuppressedDestinationResponse> {
            serializer = PutSuppressedDestinationOperationSerializer()
            deserializer = PutSuppressedDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutSuppressedDestination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Composes an email message to multiple destinations.
     */
    override suspend fun sendBulkEmail(input: SendBulkEmailRequest): SendBulkEmailResponse {
        val op = SdkHttpOperation.build<SendBulkEmailRequest, SendBulkEmailResponse> {
            serializer = SendBulkEmailOperationSerializer()
            deserializer = SendBulkEmailOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SendBulkEmail"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds an email address to the list of identities for your Amazon SES account in the current Amazon Web Services Region and attempts to verify it. As a result of executing this operation, a customized verification email is sent to the specified address.
     *
     * To use this operation, you must first create a custom verification email template. For more information about creating and using custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html) in the *Amazon SES Developer Guide*.
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun sendCustomVerificationEmail(input: SendCustomVerificationEmailRequest): SendCustomVerificationEmailResponse {
        val op = SdkHttpOperation.build<SendCustomVerificationEmailRequest, SendCustomVerificationEmailResponse> {
            serializer = SendCustomVerificationEmailOperationSerializer()
            deserializer = SendCustomVerificationEmailOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SendCustomVerificationEmail"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sends an email message. You can use the Amazon SES API v2 to send the following types of messages:
     * + **Simple** – A standard email message. When you create this type of message, you specify the sender, the recipient, and the message body, and Amazon SES assembles the message for you.
     * + **Raw** – A raw, MIME-formatted email message. When you send this type of email, you have to specify all of the message headers, as well as the message body. You can use this message type to send messages that contain attachments. The message that you specify has to be a valid MIME message.
     * + **Templated** – A message that contains personalization tags. When you send this type of email, Amazon SES API v2 automatically replaces the tags with values that you specify.
     */
    override suspend fun sendEmail(input: SendEmailRequest): SendEmailResponse {
        val op = SdkHttpOperation.build<SendEmailRequest, SendEmailResponse> {
            serializer = SendEmailOperationSerializer()
            deserializer = SendEmailOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SendEmail"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Add one or more tags (keys and values) to a specified resource. A *tag* is a label that you optionally define and associate with a resource. Tags can help you categorize and manage resources in different ways, such as by purpose, owner, environment, or other criteria. A resource can have as many as 50 tags.
     *
     * Each tag consists of a required *tag key* and an associated *tag value*, both of which you define. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a preview of the MIME content of an email when provided with a template and a set of replacement data.
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun testRenderEmailTemplate(input: TestRenderEmailTemplateRequest): TestRenderEmailTemplateResponse {
        val op = SdkHttpOperation.build<TestRenderEmailTemplateRequest, TestRenderEmailTemplateResponse> {
            serializer = TestRenderEmailTemplateOperationSerializer()
            deserializer = TestRenderEmailTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TestRenderEmailTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Remove one or more tags (keys and values) from a specified resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update the configuration of an event destination for a configuration set.
     *
     * *Events* include message sends, deliveries, opens, clicks, bounces, and complaints. *Event destinations* are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
     */
    override suspend fun updateConfigurationSetEventDestination(input: UpdateConfigurationSetEventDestinationRequest): UpdateConfigurationSetEventDestinationResponse {
        val op = SdkHttpOperation.build<UpdateConfigurationSetEventDestinationRequest, UpdateConfigurationSetEventDestinationResponse> {
            serializer = UpdateConfigurationSetEventDestinationOperationSerializer()
            deserializer = UpdateConfigurationSetEventDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateConfigurationSetEventDestination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a contact's preferences for a list. It is not necessary to specify all existing topic preferences in the TopicPreferences object, just the ones that need updating.
     */
    override suspend fun updateContact(input: UpdateContactRequest): UpdateContactResponse {
        val op = SdkHttpOperation.build<UpdateContactRequest, UpdateContactResponse> {
            serializer = UpdateContactOperationSerializer()
            deserializer = UpdateContactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateContact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates contact list metadata. This operation does a complete replacement.
     */
    override suspend fun updateContactList(input: UpdateContactListRequest): UpdateContactListResponse {
        val op = SdkHttpOperation.build<UpdateContactListRequest, UpdateContactListResponse> {
            serializer = UpdateContactListOperationSerializer()
            deserializer = UpdateContactListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateContactList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing custom verification email template.
     *
     * For more information about custom verification email templates, see [Using Custom Verification Email Templates](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html) in the *Amazon SES Developer Guide*.
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun updateCustomVerificationEmailTemplate(input: UpdateCustomVerificationEmailTemplateRequest): UpdateCustomVerificationEmailTemplateResponse {
        val op = SdkHttpOperation.build<UpdateCustomVerificationEmailTemplateRequest, UpdateCustomVerificationEmailTemplateResponse> {
            serializer = UpdateCustomVerificationEmailTemplateOperationSerializer()
            deserializer = UpdateCustomVerificationEmailTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCustomVerificationEmailTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified sending authorization policy for the given identity (an email address or a domain). This API returns successfully even if a policy with the specified name does not exist.
     *
     * This API is for the identity owner only. If you have not verified the identity, this API will return an error.
     *
     * Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun updateEmailIdentityPolicy(input: UpdateEmailIdentityPolicyRequest): UpdateEmailIdentityPolicyResponse {
        val op = SdkHttpOperation.build<UpdateEmailIdentityPolicyRequest, UpdateEmailIdentityPolicyResponse> {
            serializer = UpdateEmailIdentityPolicyOperationSerializer()
            deserializer = UpdateEmailIdentityPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateEmailIdentityPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an email template. Email templates enable you to send personalized email to one or more destinations in a single API operation. For more information, see the [Amazon SES Developer Guide](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html).
     *
     * You can execute this operation no more than once per second.
     */
    override suspend fun updateEmailTemplate(input: UpdateEmailTemplateRequest): UpdateEmailTemplateResponse {
        val op = SdkHttpOperation.build<UpdateEmailTemplateRequest, UpdateEmailTemplateResponse> {
            serializer = UpdateEmailTemplateOperationSerializer()
            deserializer = UpdateEmailTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateEmailTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ses"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "ses")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
