// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * A request to perform a predictive inbox placement test. Predictive inbox placement tests can help you predict how your messages will be handled by various email providers around the world. When you perform a predictive inbox placement test, you provide a sample message that contains the content that you plan to send to your customers. We send that message to special email addresses spread across several major email providers around the world. The test takes about 24 hours to complete. When the test is complete, you can use the `GetDeliverabilityTestReport` operation to view the results of the test.
 */
public class CreateDeliverabilityTestReportRequest private constructor(builder: Builder) {
    /**
     * The HTML body of the message that you sent when you performed the predictive inbox placement test.
     */
    public val content: aws.sdk.kotlin.services.sesv2.model.EmailContent? = builder.content
    /**
     * The email address that the predictive inbox placement test email was sent from.
     */
    public val fromEmailAddress: kotlin.String? = builder.fromEmailAddress
    /**
     * A unique name that helps you to identify the predictive inbox placement test when you retrieve the results.
     */
    public val reportName: kotlin.String? = builder.reportName
    /**
     * An array of objects that define the tags (keys and values) that you want to associate with the predictive inbox placement test.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.CreateDeliverabilityTestReportRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDeliverabilityTestReportRequest(")
        append("content=$content,")
        append("fromEmailAddress=$fromEmailAddress,")
        append("reportName=$reportName,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = content?.hashCode() ?: 0
        result = 31 * result + (fromEmailAddress?.hashCode() ?: 0)
        result = 31 * result + (reportName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDeliverabilityTestReportRequest

        if (content != other.content) return false
        if (fromEmailAddress != other.fromEmailAddress) return false
        if (reportName != other.reportName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.CreateDeliverabilityTestReportRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The HTML body of the message that you sent when you performed the predictive inbox placement test.
         */
        public var content: aws.sdk.kotlin.services.sesv2.model.EmailContent? = null
        /**
         * The email address that the predictive inbox placement test email was sent from.
         */
        public var fromEmailAddress: kotlin.String? = null
        /**
         * A unique name that helps you to identify the predictive inbox placement test when you retrieve the results.
         */
        public var reportName: kotlin.String? = null
        /**
         * An array of objects that define the tags (keys and values) that you want to associate with the predictive inbox placement test.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.CreateDeliverabilityTestReportRequest) : this() {
            this.content = x.content
            this.fromEmailAddress = x.fromEmailAddress
            this.reportName = x.reportName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.CreateDeliverabilityTestReportRequest = CreateDeliverabilityTestReportRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sesv2.model.EmailContent] inside the given [block]
         */
        public fun content(block: aws.sdk.kotlin.services.sesv2.model.EmailContent.Builder.() -> kotlin.Unit) {
            this.content = aws.sdk.kotlin.services.sesv2.model.EmailContent.invoke(block)
        }
    }
}
