// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that contains the deliverability data for a specific campaign. This data is available for a campaign only if the campaign sent email by using a domain that the Deliverability dashboard is enabled for (`PutDeliverabilityDashboardOption` operation).
 */
public class DomainDeliverabilityCampaign private constructor(builder: Builder) {
    /**
     * The unique identifier for the campaign. The Deliverability dashboard automatically generates and assigns this identifier to a campaign.
     */
    public val campaignId: kotlin.String? = builder.campaignId
    /**
     * The percentage of email messages that were deleted by recipients, without being opened first. Due to technical limitations, this value only includes recipients who opened the message by using an email client that supports images.
     */
    public val deleteRate: kotlin.Double? = builder.deleteRate
    /**
     * The major email providers who handled the email message.
     */
    public val esps: List<String>? = builder.esps
    /**
     * The first time, in Unix time format, when the email message was delivered to any recipient's inbox. This value can help you determine how long it took for a campaign to deliver an email message.
     */
    public val firstSeenDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.firstSeenDateTime
    /**
     * The verified email address that the email message was sent from.
     */
    public val fromAddress: kotlin.String? = builder.fromAddress
    /**
     * The URL of an image that contains a snapshot of the email message that was sent.
     */
    public val imageUrl: kotlin.String? = builder.imageUrl
    /**
     * The number of email messages that were delivered to recipients’ inboxes.
     */
    public val inboxCount: kotlin.Long? = builder.inboxCount
    /**
     * The last time, in Unix time format, when the email message was delivered to any recipient's inbox. This value can help you determine how long it took for a campaign to deliver an email message.
     */
    public val lastSeenDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastSeenDateTime
    /**
     * The projected number of recipients that the email message was sent to.
     */
    public val projectedVolume: kotlin.Long? = builder.projectedVolume
    /**
     * The percentage of email messages that were opened and then deleted by recipients. Due to technical limitations, this value only includes recipients who opened the message by using an email client that supports images.
     */
    public val readDeleteRate: kotlin.Double? = builder.readDeleteRate
    /**
     * The percentage of email messages that were opened by recipients. Due to technical limitations, this value only includes recipients who opened the message by using an email client that supports images.
     */
    public val readRate: kotlin.Double? = builder.readRate
    /**
     * The IP addresses that were used to send the email message.
     */
    public val sendingIps: List<String>? = builder.sendingIps
    /**
     * The number of email messages that were delivered to recipients' spam or junk mail folders.
     */
    public val spamCount: kotlin.Long? = builder.spamCount
    /**
     * The subject line, or title, of the email message.
     */
    public val subject: kotlin.String? = builder.subject

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.DomainDeliverabilityCampaign = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainDeliverabilityCampaign(")
        append("campaignId=$campaignId,")
        append("deleteRate=$deleteRate,")
        append("esps=$esps,")
        append("firstSeenDateTime=$firstSeenDateTime,")
        append("fromAddress=$fromAddress,")
        append("imageUrl=$imageUrl,")
        append("inboxCount=$inboxCount,")
        append("lastSeenDateTime=$lastSeenDateTime,")
        append("projectedVolume=$projectedVolume,")
        append("readDeleteRate=$readDeleteRate,")
        append("readRate=$readRate,")
        append("sendingIps=$sendingIps,")
        append("spamCount=$spamCount,")
        append("subject=$subject)")
    }

    override fun hashCode(): kotlin.Int {
        var result = campaignId?.hashCode() ?: 0
        result = 31 * result + (deleteRate?.hashCode() ?: 0)
        result = 31 * result + (esps?.hashCode() ?: 0)
        result = 31 * result + (firstSeenDateTime?.hashCode() ?: 0)
        result = 31 * result + (fromAddress?.hashCode() ?: 0)
        result = 31 * result + (imageUrl?.hashCode() ?: 0)
        result = 31 * result + (inboxCount?.hashCode() ?: 0)
        result = 31 * result + (lastSeenDateTime?.hashCode() ?: 0)
        result = 31 * result + (projectedVolume?.hashCode() ?: 0)
        result = 31 * result + (readDeleteRate?.hashCode() ?: 0)
        result = 31 * result + (readRate?.hashCode() ?: 0)
        result = 31 * result + (sendingIps?.hashCode() ?: 0)
        result = 31 * result + (spamCount?.hashCode() ?: 0)
        result = 31 * result + (subject?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainDeliverabilityCampaign

        if (campaignId != other.campaignId) return false
        if (deleteRate != other.deleteRate) return false
        if (esps != other.esps) return false
        if (firstSeenDateTime != other.firstSeenDateTime) return false
        if (fromAddress != other.fromAddress) return false
        if (imageUrl != other.imageUrl) return false
        if (inboxCount != other.inboxCount) return false
        if (lastSeenDateTime != other.lastSeenDateTime) return false
        if (projectedVolume != other.projectedVolume) return false
        if (readDeleteRate != other.readDeleteRate) return false
        if (readRate != other.readRate) return false
        if (sendingIps != other.sendingIps) return false
        if (spamCount != other.spamCount) return false
        if (subject != other.subject) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.DomainDeliverabilityCampaign = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the campaign. The Deliverability dashboard automatically generates and assigns this identifier to a campaign.
         */
        public var campaignId: kotlin.String? = null
        /**
         * The percentage of email messages that were deleted by recipients, without being opened first. Due to technical limitations, this value only includes recipients who opened the message by using an email client that supports images.
         */
        public var deleteRate: kotlin.Double? = null
        /**
         * The major email providers who handled the email message.
         */
        public var esps: List<String>? = null
        /**
         * The first time, in Unix time format, when the email message was delivered to any recipient's inbox. This value can help you determine how long it took for a campaign to deliver an email message.
         */
        public var firstSeenDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The verified email address that the email message was sent from.
         */
        public var fromAddress: kotlin.String? = null
        /**
         * The URL of an image that contains a snapshot of the email message that was sent.
         */
        public var imageUrl: kotlin.String? = null
        /**
         * The number of email messages that were delivered to recipients’ inboxes.
         */
        public var inboxCount: kotlin.Long? = null
        /**
         * The last time, in Unix time format, when the email message was delivered to any recipient's inbox. This value can help you determine how long it took for a campaign to deliver an email message.
         */
        public var lastSeenDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The projected number of recipients that the email message was sent to.
         */
        public var projectedVolume: kotlin.Long? = null
        /**
         * The percentage of email messages that were opened and then deleted by recipients. Due to technical limitations, this value only includes recipients who opened the message by using an email client that supports images.
         */
        public var readDeleteRate: kotlin.Double? = null
        /**
         * The percentage of email messages that were opened by recipients. Due to technical limitations, this value only includes recipients who opened the message by using an email client that supports images.
         */
        public var readRate: kotlin.Double? = null
        /**
         * The IP addresses that were used to send the email message.
         */
        public var sendingIps: List<String>? = null
        /**
         * The number of email messages that were delivered to recipients' spam or junk mail folders.
         */
        public var spamCount: kotlin.Long? = null
        /**
         * The subject line, or title, of the email message.
         */
        public var subject: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.DomainDeliverabilityCampaign) : this() {
            this.campaignId = x.campaignId
            this.deleteRate = x.deleteRate
            this.esps = x.esps
            this.firstSeenDateTime = x.firstSeenDateTime
            this.fromAddress = x.fromAddress
            this.imageUrl = x.imageUrl
            this.inboxCount = x.inboxCount
            this.lastSeenDateTime = x.lastSeenDateTime
            this.projectedVolume = x.projectedVolume
            this.readDeleteRate = x.readDeleteRate
            this.readRate = x.readRate
            this.sendingIps = x.sendingIps
            this.spamCount = x.spamCount
            this.subject = x.subject
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.DomainDeliverabilityCampaign = DomainDeliverabilityCampaign(this)
    }
}
