// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that shows the status of the Deliverability dashboard.
 */
public class GetDeliverabilityDashboardOptionsResponse private constructor(builder: Builder) {
    /**
     * The current status of your Deliverability dashboard subscription. If this value is `PENDING_EXPIRATION`, your subscription is scheduled to expire at the end of the current calendar month.
     */
    public val accountStatus: aws.sdk.kotlin.services.sesv2.model.DeliverabilityDashboardAccountStatus? = builder.accountStatus
    /**
     * An array of objects, one for each verified domain that you use to send email and currently has an active Deliverability dashboard subscription that isn’t scheduled to expire at the end of the current calendar month.
     */
    public val activeSubscribedDomains: List<DomainDeliverabilityTrackingOption>? = builder.activeSubscribedDomains
    /**
     * Specifies whether the Deliverability dashboard is enabled. If this value is `true`, the dashboard is enabled.
     */
    public val dashboardEnabled: kotlin.Boolean = builder.dashboardEnabled
    /**
     * An array of objects, one for each verified domain that you use to send email and currently has an active Deliverability dashboard subscription that's scheduled to expire at the end of the current calendar month.
     */
    public val pendingExpirationSubscribedDomains: List<DomainDeliverabilityTrackingOption>? = builder.pendingExpirationSubscribedDomains
    /**
     * The date, in Unix time format, when your current subscription to the Deliverability dashboard is scheduled to expire, if your subscription is scheduled to expire at the end of the current calendar month. This value is null if you have an active subscription that isn’t due to expire at the end of the month.
     */
    public val subscriptionExpiryDate: aws.smithy.kotlin.runtime.time.Instant? = builder.subscriptionExpiryDate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.GetDeliverabilityDashboardOptionsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetDeliverabilityDashboardOptionsResponse(")
        append("accountStatus=$accountStatus,")
        append("activeSubscribedDomains=$activeSubscribedDomains,")
        append("dashboardEnabled=$dashboardEnabled,")
        append("pendingExpirationSubscribedDomains=$pendingExpirationSubscribedDomains,")
        append("subscriptionExpiryDate=$subscriptionExpiryDate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountStatus?.hashCode() ?: 0
        result = 31 * result + (activeSubscribedDomains?.hashCode() ?: 0)
        result = 31 * result + (dashboardEnabled.hashCode())
        result = 31 * result + (pendingExpirationSubscribedDomains?.hashCode() ?: 0)
        result = 31 * result + (subscriptionExpiryDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetDeliverabilityDashboardOptionsResponse

        if (accountStatus != other.accountStatus) return false
        if (activeSubscribedDomains != other.activeSubscribedDomains) return false
        if (dashboardEnabled != other.dashboardEnabled) return false
        if (pendingExpirationSubscribedDomains != other.pendingExpirationSubscribedDomains) return false
        if (subscriptionExpiryDate != other.subscriptionExpiryDate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.GetDeliverabilityDashboardOptionsResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The current status of your Deliverability dashboard subscription. If this value is `PENDING_EXPIRATION`, your subscription is scheduled to expire at the end of the current calendar month.
         */
        public var accountStatus: aws.sdk.kotlin.services.sesv2.model.DeliverabilityDashboardAccountStatus? = null
        /**
         * An array of objects, one for each verified domain that you use to send email and currently has an active Deliverability dashboard subscription that isn’t scheduled to expire at the end of the current calendar month.
         */
        public var activeSubscribedDomains: List<DomainDeliverabilityTrackingOption>? = null
        /**
         * Specifies whether the Deliverability dashboard is enabled. If this value is `true`, the dashboard is enabled.
         */
        public var dashboardEnabled: kotlin.Boolean = false
        /**
         * An array of objects, one for each verified domain that you use to send email and currently has an active Deliverability dashboard subscription that's scheduled to expire at the end of the current calendar month.
         */
        public var pendingExpirationSubscribedDomains: List<DomainDeliverabilityTrackingOption>? = null
        /**
         * The date, in Unix time format, when your current subscription to the Deliverability dashboard is scheduled to expire, if your subscription is scheduled to expire at the end of the current calendar month. This value is null if you have an active subscription that isn’t due to expire at the end of the month.
         */
        public var subscriptionExpiryDate: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.GetDeliverabilityDashboardOptionsResponse) : this() {
            this.accountStatus = x.accountStatus
            this.activeSubscribedDomains = x.activeSubscribedDomains
            this.dashboardEnabled = x.dashboardEnabled
            this.pendingExpirationSubscribedDomains = x.pendingExpirationSubscribedDomains
            this.subscriptionExpiryDate = x.subscriptionExpiryDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.GetDeliverabilityDashboardOptionsResponse = GetDeliverabilityDashboardOptionsResponse(this)
    }
}
