// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A request to obtain a list of email destinations that are on the suppression list for your account.
 */
public class ListSuppressedDestinationsRequest private constructor(builder: Builder) {
    /**
     * Used to filter the list of suppressed email destinations so that it only includes addresses that were added to the list before a specific date. The date that you specify should be in Unix time format.
     */
    public val endDate: aws.smithy.kotlin.runtime.time.Instant? = builder.endDate
    /**
     * A token returned from a previous call to `ListSuppressedDestinations` to indicate the position in the list of suppressed email addresses.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The number of results to show in a single call to `ListSuppressedDestinations`. If the number of results is larger than the number you specified in this parameter, then the response includes a `NextToken` element, which you can use to obtain additional results.
     */
    public val pageSize: kotlin.Int? = builder.pageSize
    /**
     * The factors that caused the email address to be added to .
     */
    public val reasons: List<SuppressionListReason>? = builder.reasons
    /**
     * Used to filter the list of suppressed email destinations so that it only includes addresses that were added to the list after a specific date. The date that you specify should be in Unix time format.
     */
    public val startDate: aws.smithy.kotlin.runtime.time.Instant? = builder.startDate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.ListSuppressedDestinationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListSuppressedDestinationsRequest(")
        append("endDate=$endDate,")
        append("nextToken=$nextToken,")
        append("pageSize=$pageSize,")
        append("reasons=$reasons,")
        append("startDate=$startDate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endDate?.hashCode() ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (pageSize ?: 0)
        result = 31 * result + (reasons?.hashCode() ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListSuppressedDestinationsRequest

        if (endDate != other.endDate) return false
        if (nextToken != other.nextToken) return false
        if (pageSize != other.pageSize) return false
        if (reasons != other.reasons) return false
        if (startDate != other.startDate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.ListSuppressedDestinationsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Used to filter the list of suppressed email destinations so that it only includes addresses that were added to the list before a specific date. The date that you specify should be in Unix time format.
         */
        public var endDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A token returned from a previous call to `ListSuppressedDestinations` to indicate the position in the list of suppressed email addresses.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The number of results to show in a single call to `ListSuppressedDestinations`. If the number of results is larger than the number you specified in this parameter, then the response includes a `NextToken` element, which you can use to obtain additional results.
         */
        public var pageSize: kotlin.Int? = null
        /**
         * The factors that caused the email address to be added to .
         */
        public var reasons: List<SuppressionListReason>? = null
        /**
         * Used to filter the list of suppressed email destinations so that it only includes addresses that were added to the list after a specific date. The date that you specify should be in Unix time format.
         */
        public var startDate: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.ListSuppressedDestinationsRequest) : this() {
            this.endDate = x.endDate
            this.nextToken = x.nextToken
            this.pageSize = x.pageSize
            this.reasons = x.reasons
            this.startDate = x.startDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.ListSuppressedDestinationsRequest = ListSuppressedDestinationsRequest(this)
    }
}
