// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * A request to change the account suppression list preferences for a specific configuration set.
 */
public class PutConfigurationSetSuppressionOptionsRequest private constructor(builder: Builder) {
    /**
     * The name of the configuration set to change the suppression list preferences for.
     */
    public val configurationSetName: kotlin.String? = requireNotNull(builder.configurationSetName) { "A non-null value must be provided for configurationSetName" }
    /**
     * A list that contains the reasons that email addresses are automatically added to the suppression list for your account. This list can contain any or all of the following:
     * + `COMPLAINT` – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.
     * + `BOUNCE` – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.
     */
    public val suppressedReasons: List<SuppressionListReason>? = builder.suppressedReasons

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.PutConfigurationSetSuppressionOptionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutConfigurationSetSuppressionOptionsRequest(")
        append("configurationSetName=$configurationSetName,")
        append("suppressedReasons=$suppressedReasons)")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationSetName?.hashCode() ?: 0
        result = 31 * result + (suppressedReasons?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutConfigurationSetSuppressionOptionsRequest

        if (configurationSetName != other.configurationSetName) return false
        if (suppressedReasons != other.suppressedReasons) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.PutConfigurationSetSuppressionOptionsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the configuration set to change the suppression list preferences for.
         */
        public var configurationSetName: kotlin.String? = null
        /**
         * A list that contains the reasons that email addresses are automatically added to the suppression list for your account. This list can contain any or all of the following:
         * + `COMPLAINT` – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.
         * + `BOUNCE` – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.
         */
        public var suppressedReasons: List<SuppressionListReason>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.PutConfigurationSetSuppressionOptionsRequest) : this() {
            this.configurationSetName = x.configurationSetName
            this.suppressedReasons = x.suppressedReasons
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.PutConfigurationSetSuppressionOptionsRequest = PutConfigurationSetSuppressionOptionsRequest(this)
    }
}
