// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * A request to configure the custom MAIL FROM domain for a verified identity.
 */
public class PutEmailIdentityMailFromAttributesRequest private constructor(builder: Builder) {
    /**
     * The action to take if the required MX record isn't found when you send an email. When you set this value to `UseDefaultValue`, the mail is sent using *amazonses.com* as the MAIL FROM domain. When you set this value to `RejectMessage`, the Amazon SES API v2 returns a `MailFromDomainNotVerified` error, and doesn't attempt to deliver the email.
     *
     * These behaviors are taken when the custom MAIL FROM domain configuration is in the `Pending`, `Failed`, and `TemporaryFailure` states.
     */
    public val behaviorOnMxFailure: aws.sdk.kotlin.services.sesv2.model.BehaviorOnMxFailure? = builder.behaviorOnMxFailure
    /**
     * The verified email identity.
     */
    public val emailIdentity: kotlin.String? = requireNotNull(builder.emailIdentity) { "A non-null value must be provided for emailIdentity" }
    /**
     * The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must meet the following criteria:
     * + It has to be a subdomain of the verified identity.
     * + It can't be used to receive email.
     * + It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback forwarding emails.
     */
    public val mailFromDomain: kotlin.String? = builder.mailFromDomain

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.PutEmailIdentityMailFromAttributesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutEmailIdentityMailFromAttributesRequest(")
        append("behaviorOnMxFailure=$behaviorOnMxFailure,")
        append("emailIdentity=$emailIdentity,")
        append("mailFromDomain=$mailFromDomain)")
    }

    override fun hashCode(): kotlin.Int {
        var result = behaviorOnMxFailure?.hashCode() ?: 0
        result = 31 * result + (emailIdentity?.hashCode() ?: 0)
        result = 31 * result + (mailFromDomain?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutEmailIdentityMailFromAttributesRequest

        if (behaviorOnMxFailure != other.behaviorOnMxFailure) return false
        if (emailIdentity != other.emailIdentity) return false
        if (mailFromDomain != other.mailFromDomain) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.PutEmailIdentityMailFromAttributesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action to take if the required MX record isn't found when you send an email. When you set this value to `UseDefaultValue`, the mail is sent using *amazonses.com* as the MAIL FROM domain. When you set this value to `RejectMessage`, the Amazon SES API v2 returns a `MailFromDomainNotVerified` error, and doesn't attempt to deliver the email.
         *
         * These behaviors are taken when the custom MAIL FROM domain configuration is in the `Pending`, `Failed`, and `TemporaryFailure` states.
         */
        public var behaviorOnMxFailure: aws.sdk.kotlin.services.sesv2.model.BehaviorOnMxFailure? = null
        /**
         * The verified email identity.
         */
        public var emailIdentity: kotlin.String? = null
        /**
         * The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must meet the following criteria:
         * + It has to be a subdomain of the verified identity.
         * + It can't be used to receive email.
         * + It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback forwarding emails.
         */
        public var mailFromDomain: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.PutEmailIdentityMailFromAttributesRequest) : this() {
            this.behaviorOnMxFailure = x.behaviorOnMxFailure
            this.emailIdentity = x.emailIdentity
            this.mailFromDomain = x.mailFromDomain
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.PutEmailIdentityMailFromAttributesRequest = PutEmailIdentityMailFromAttributesRequest(this)
    }
}
