// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * An object that contains information about the per-day and per-second sending limits for your Amazon SES account in the current Amazon Web Services Region.
 */
public class SendQuota private constructor(builder: Builder) {
    /**
     * The maximum number of emails that you can send in the current Amazon Web Services Region over a 24-hour period. This value is also called your *sending quota*.
     */
    public val max24HourSend: kotlin.Double = builder.max24HourSend
    /**
     * The maximum number of emails that you can send per second in the current Amazon Web Services Region. This value is also called your *maximum sending rate* or your *maximum TPS (transactions per second) rate*.
     */
    public val maxSendRate: kotlin.Double = builder.maxSendRate
    /**
     * The number of emails sent from your Amazon SES account in the current Amazon Web Services Region over the past 24 hours.
     */
    public val sentLast24Hours: kotlin.Double = builder.sentLast24Hours

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.SendQuota = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SendQuota(")
        append("max24HourSend=$max24HourSend,")
        append("maxSendRate=$maxSendRate,")
        append("sentLast24Hours=$sentLast24Hours)")
    }

    override fun hashCode(): kotlin.Int {
        var result = max24HourSend.hashCode()
        result = 31 * result + (maxSendRate.hashCode())
        result = 31 * result + (sentLast24Hours.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SendQuota

        if (max24HourSend != other.max24HourSend) return false
        if (maxSendRate != other.maxSendRate) return false
        if (sentLast24Hours != other.sentLast24Hours) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.SendQuota = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of emails that you can send in the current Amazon Web Services Region over a 24-hour period. This value is also called your *sending quota*.
         */
        public var max24HourSend: kotlin.Double = 0.0
        /**
         * The maximum number of emails that you can send per second in the current Amazon Web Services Region. This value is also called your *maximum sending rate* or your *maximum TPS (transactions per second) rate*.
         */
        public var maxSendRate: kotlin.Double = 0.0
        /**
         * The number of emails sent from your Amazon SES account in the current Amazon Web Services Region over the past 24 hours.
         */
        public var sentLast24Hours: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.SendQuota) : this() {
            this.max24HourSend = x.max24HourSend
            this.maxSendRate = x.maxSendRate
            this.sentLast24Hours = x.sentLast24Hours
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.SendQuota = SendQuota(this)
    }
}
