// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.model



/**
 * An object that defines the email template to use for an email message, and the values to use for any message variables in that template. An *email template* is a type of message template that contains content that you want to define, save, and reuse in email messages that you send.
 */
public class Template private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the template.
     */
    public val templateArn: kotlin.String? = builder.templateArn
    /**
     * An object that defines the values to use for message variables in the template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the value to use for that variable.
     */
    public val templateData: kotlin.String? = builder.templateData
    /**
     * The name of the template. You will refer to this name when you send email using the `SendTemplatedEmail` or `SendBulkTemplatedEmail` operations.
     */
    public val templateName: kotlin.String? = builder.templateName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sesv2.model.Template = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Template(")
        append("templateArn=$templateArn,")
        append("templateData=$templateData,")
        append("templateName=$templateName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = templateArn?.hashCode() ?: 0
        result = 31 * result + (templateData?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Template

        if (templateArn != other.templateArn) return false
        if (templateData != other.templateData) return false
        if (templateName != other.templateName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sesv2.model.Template = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the template.
         */
        public var templateArn: kotlin.String? = null
        /**
         * An object that defines the values to use for message variables in the template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the value to use for that variable.
         */
        public var templateData: kotlin.String? = null
        /**
         * The name of the template. You will refer to this name when you send email using the `SendTemplatedEmail` or `SendBulkTemplatedEmail` operations.
         */
        public var templateName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sesv2.model.Template) : this() {
            this.templateArn = x.templateArn
            this.templateData = x.templateData
            this.templateName = x.templateName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sesv2.model.Template = Template(this)
    }
}
