// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sesv2.model.CreateDeliverabilityTestReportResponse
import aws.sdk.kotlin.services.sesv2.model.DeliverabilityTestStatus
import aws.sdk.kotlin.services.sesv2.model.SesV2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateDeliverabilityTestReportOperationDeserializer: HttpDeserialize<CreateDeliverabilityTestReportResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateDeliverabilityTestReportResponse {
        if (!response.status.isSuccess()) {
            throwCreateDeliverabilityTestReportError(context, response)
        }
        val builder = CreateDeliverabilityTestReportResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateDeliverabilityTestReportOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateDeliverabilityTestReportError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SesV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccountSuspendedException" -> AccountSuspendedExceptionDeserializer().deserialize(context, wrappedResponse)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConcurrentModificationException" -> ConcurrentModificationExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "MailFromDomainNotVerifiedException" -> MailFromDomainNotVerifiedExceptionDeserializer().deserialize(context, wrappedResponse)
        "MessageRejected" -> MessageRejectedDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "SendingPausedException" -> SendingPausedExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SesV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDeliverabilityTestReportOperationBody(builder: CreateDeliverabilityTestReportResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DELIVERABILITYTESTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeliverabilityTestStatus"))
    val REPORTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ReportId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DELIVERABILITYTESTSTATUS_DESCRIPTOR)
        field(REPORTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DELIVERABILITYTESTSTATUS_DESCRIPTOR.index -> builder.deliverabilityTestStatus = deserializeString().let { DeliverabilityTestStatus.fromValue(it) }
                REPORTID_DESCRIPTOR.index -> builder.reportId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
