// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sesv2.model.DeliveryOptions
import aws.sdk.kotlin.services.sesv2.model.GetConfigurationSetResponse
import aws.sdk.kotlin.services.sesv2.model.ReputationOptions
import aws.sdk.kotlin.services.sesv2.model.SendingOptions
import aws.sdk.kotlin.services.sesv2.model.SesV2Exception
import aws.sdk.kotlin.services.sesv2.model.SuppressionOptions
import aws.sdk.kotlin.services.sesv2.model.Tag
import aws.sdk.kotlin.services.sesv2.model.TrackingOptions
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetConfigurationSetOperationDeserializer: HttpDeserialize<GetConfigurationSetResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetConfigurationSetResponse {
        if (!response.status.isSuccess()) {
            throwGetConfigurationSetError(context, response)
        }
        val builder = GetConfigurationSetResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetConfigurationSetOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetConfigurationSetError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SesV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SesV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetConfigurationSetOperationBody(builder: GetConfigurationSetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONFIGURATIONSETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConfigurationSetName"))
    val DELIVERYOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DeliveryOptions"))
    val REPUTATIONOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ReputationOptions"))
    val SENDINGOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SendingOptions"))
    val SUPPRESSIONOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SuppressionOptions"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val TRACKINGOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TrackingOptions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONFIGURATIONSETNAME_DESCRIPTOR)
        field(DELIVERYOPTIONS_DESCRIPTOR)
        field(REPUTATIONOPTIONS_DESCRIPTOR)
        field(SENDINGOPTIONS_DESCRIPTOR)
        field(SUPPRESSIONOPTIONS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TRACKINGOPTIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONFIGURATIONSETNAME_DESCRIPTOR.index -> builder.configurationSetName = deserializeString()
                DELIVERYOPTIONS_DESCRIPTOR.index -> builder.deliveryOptions = deserializeDeliveryOptionsDocument(deserializer)
                REPUTATIONOPTIONS_DESCRIPTOR.index -> builder.reputationOptions = deserializeReputationOptionsDocument(deserializer)
                SENDINGOPTIONS_DESCRIPTOR.index -> builder.sendingOptions = deserializeSendingOptionsDocument(deserializer)
                SUPPRESSIONOPTIONS_DESCRIPTOR.index -> builder.suppressionOptions = deserializeSuppressionOptionsDocument(deserializer)
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TRACKINGOPTIONS_DESCRIPTOR.index -> builder.trackingOptions = deserializeTrackingOptionsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
