// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sesv2.model.GetCustomVerificationEmailTemplateResponse
import aws.sdk.kotlin.services.sesv2.model.SesV2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetCustomVerificationEmailTemplateOperationDeserializer: HttpDeserialize<GetCustomVerificationEmailTemplateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetCustomVerificationEmailTemplateResponse {
        if (!response.status.isSuccess()) {
            throwGetCustomVerificationEmailTemplateError(context, response)
        }
        val builder = GetCustomVerificationEmailTemplateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetCustomVerificationEmailTemplateOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetCustomVerificationEmailTemplateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SesV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SesV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetCustomVerificationEmailTemplateOperationBody(builder: GetCustomVerificationEmailTemplateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILUREREDIRECTIONURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureRedirectionURL"))
    val FROMEMAILADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FromEmailAddress"))
    val SUCCESSREDIRECTIONURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SuccessRedirectionURL"))
    val TEMPLATECONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TemplateContent"))
    val TEMPLATENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TemplateName"))
    val TEMPLATESUBJECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TemplateSubject"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILUREREDIRECTIONURL_DESCRIPTOR)
        field(FROMEMAILADDRESS_DESCRIPTOR)
        field(SUCCESSREDIRECTIONURL_DESCRIPTOR)
        field(TEMPLATECONTENT_DESCRIPTOR)
        field(TEMPLATENAME_DESCRIPTOR)
        field(TEMPLATESUBJECT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILUREREDIRECTIONURL_DESCRIPTOR.index -> builder.failureRedirectionUrl = deserializeString()
                FROMEMAILADDRESS_DESCRIPTOR.index -> builder.fromEmailAddress = deserializeString()
                SUCCESSREDIRECTIONURL_DESCRIPTOR.index -> builder.successRedirectionUrl = deserializeString()
                TEMPLATECONTENT_DESCRIPTOR.index -> builder.templateContent = deserializeString()
                TEMPLATENAME_DESCRIPTOR.index -> builder.templateName = deserializeString()
                TEMPLATESUBJECT_DESCRIPTOR.index -> builder.templateSubject = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
