// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.transform

import aws.sdk.kotlin.services.sesv2.model.ListContactsFilter
import aws.sdk.kotlin.services.sesv2.model.ListContactsRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.parameters
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListContactsOperationSerializer: HttpSerialize<ListContactsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListContactsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            val pathSegments = listOf(
                "v2",
                "email",
                "contact-lists",
                "${input.contactListName}".encodeLabel(),
                "contacts",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.nextToken != null) append("NextToken", input.nextToken)
                if (input.pageSize != null) append("PageSize", "${input.pageSize}")
            }
        }

        val payload = serializeListContactsOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeListContactsOperationBody(context: ExecutionContext, input: ListContactsRequest): ByteArray {
    val serializer = JsonSerializer()
    val FILTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Filter"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FILTER_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.filter?.let { field(FILTER_DESCRIPTOR, it, ::serializeListContactsFilterDocument) }
    }
    return serializer.toByteArray()
}
