// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sesv2.model.DeliverabilityTestReport
import aws.sdk.kotlin.services.sesv2.model.ListDeliverabilityTestReportsResponse
import aws.sdk.kotlin.services.sesv2.model.SesV2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListDeliverabilityTestReportsOperationDeserializer: HttpDeserialize<ListDeliverabilityTestReportsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListDeliverabilityTestReportsResponse {
        if (!response.status.isSuccess()) {
            throwListDeliverabilityTestReportsError(context, response)
        }
        val builder = ListDeliverabilityTestReportsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListDeliverabilityTestReportsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListDeliverabilityTestReportsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SesV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SesV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListDeliverabilityTestReportsOperationBody(builder: ListDeliverabilityTestReportsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DELIVERABILITYTESTREPORTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DeliverabilityTestReports"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DELIVERABILITYTESTREPORTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DELIVERABILITYTESTREPORTS_DESCRIPTOR.index -> builder.deliverabilityTestReports =
                    deserializer.deserializeList(DELIVERABILITYTESTREPORTS_DESCRIPTOR) {
                        val col0 = mutableListOf<DeliverabilityTestReport>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDeliverabilityTestReportDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
