// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sesv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sesv2.model.DkimStatus
import aws.sdk.kotlin.services.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse
import aws.sdk.kotlin.services.sesv2.model.SesV2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutEmailIdentityDkimSigningAttributesOperationDeserializer: HttpDeserialize<PutEmailIdentityDkimSigningAttributesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutEmailIdentityDkimSigningAttributesResponse {
        if (!response.status.isSuccess()) {
            throwPutEmailIdentityDkimSigningAttributesError(context, response)
        }
        val builder = PutEmailIdentityDkimSigningAttributesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutEmailIdentityDkimSigningAttributesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPutEmailIdentityDkimSigningAttributesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SesV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SesV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutEmailIdentityDkimSigningAttributesOperationBody(builder: PutEmailIdentityDkimSigningAttributesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DKIMSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DkimStatus"))
    val DKIMTOKENS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DkimTokens"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DKIMSTATUS_DESCRIPTOR)
        field(DKIMTOKENS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DKIMSTATUS_DESCRIPTOR.index -> builder.dkimStatus = deserializeString().let { DkimStatus.fromValue(it) }
                DKIMTOKENS_DESCRIPTOR.index -> builder.dkimTokens =
                    deserializer.deserializeList(DKIMTOKENS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
