// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.shield.internal

import aws.sdk.kotlin.runtime.ClientException
import aws.sdk.kotlin.runtime.endpoint.AwsEndpoint
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.endpoint.CredentialScope
import aws.sdk.kotlin.runtime.endpoint.internal.EndpointDefinition
import aws.sdk.kotlin.runtime.endpoint.internal.Partition
import aws.sdk.kotlin.runtime.endpoint.internal.resolveEndpoint

internal class DefaultEndpointResolver : AwsEndpointResolver {
    override suspend fun resolve(service: String, region: String): AwsEndpoint {
        return resolveEndpoint(servicePartitions, region) ?: throw ClientException("unable to resolve endpoint for region: $region")
    }
}

private val servicePartitions = listOf(
    Partition(
        id = "aws",
        regionRegex = Regex("^(us|eu|ap|sa|ca|me|af)\\-\\w+\\-\\d+$"),
        partitionEndpoint = "aws-global",
        isRegionalized = false,
        defaults = EndpointDefinition(
            hostname = "shield.{region}.amazonaws.com",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "aws-global" to EndpointDefinition(
                hostname = "shield.us-east-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-1",),
            ),
            "fips-aws-global" to EndpointDefinition(
                hostname = "shield-fips.us-east-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-1",),
            ),
        )
    ),
    Partition(
        id = "aws-cn",
        regionRegex = Regex("^cn\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "shield.{region}.amazonaws.com.cn",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
        )
    ),
    Partition(
        id = "aws-iso",
        regionRegex = Regex("^us\\-iso\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "shield.{region}.c2s.ic.gov",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
        )
    ),
    Partition(
        id = "aws-iso-b",
        regionRegex = Regex("^us\\-isob\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "shield.{region}.sc2s.sgov.gov",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
        )
    ),
    Partition(
        id = "aws-us-gov",
        regionRegex = Regex("^us\\-gov\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "shield.{region}.amazonaws.com",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
        )
    ),
)
