// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.shield.model



/**
 * The automatic application layer DDoS mitigation settings for a Protection. This configuration determines whether Shield Advanced automatically manages rules in the web ACL in order to respond to application layer events that Shield Advanced determines to be DDoS attacks.
 */
public class ApplicationLayerAutomaticResponseConfiguration private constructor(builder: Builder) {
    /**
     * Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on behalf of the protected resource in response to DDoS attacks. You specify this as part of the configuration for the automatic application layer DDoS mitigation feature, when you enable or update automatic mitigation. Shield Advanced creates the WAF rules in a Shield Advanced-managed rule group, inside the web ACL that you have associated with the resource.
     */
    public val action: aws.sdk.kotlin.services.shield.model.ResponseAction? = builder.action
    /**
     * Indicates whether automatic application layer DDoS mitigation is enabled for the protection.
     */
    public val status: aws.sdk.kotlin.services.shield.model.ApplicationLayerAutomaticResponseStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.shield.model.ApplicationLayerAutomaticResponseConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationLayerAutomaticResponseConfiguration(")
        append("action=$action,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApplicationLayerAutomaticResponseConfiguration

        if (action != other.action) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.shield.model.ApplicationLayerAutomaticResponseConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the action setting that Shield Advanced should use in the WAF rules that it creates on behalf of the protected resource in response to DDoS attacks. You specify this as part of the configuration for the automatic application layer DDoS mitigation feature, when you enable or update automatic mitigation. Shield Advanced creates the WAF rules in a Shield Advanced-managed rule group, inside the web ACL that you have associated with the resource.
         */
        public var action: aws.sdk.kotlin.services.shield.model.ResponseAction? = null
        /**
         * Indicates whether automatic application layer DDoS mitigation is enabled for the protection.
         */
        public var status: aws.sdk.kotlin.services.shield.model.ApplicationLayerAutomaticResponseStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.shield.model.ApplicationLayerAutomaticResponseConfiguration) : this() {
            this.action = x.action
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.shield.model.ApplicationLayerAutomaticResponseConfiguration = ApplicationLayerAutomaticResponseConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.shield.model.ResponseAction] inside the given [block]
         */
        public fun action(block: aws.sdk.kotlin.services.shield.model.ResponseAction.Builder.() -> kotlin.Unit) {
            this.action = aws.sdk.kotlin.services.shield.model.ResponseAction.invoke(block)
        }
    }
}
