// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.shield.model



public class CreateProtectionRequest private constructor(builder: Builder) {
    /**
     * Friendly name for the `Protection` you are creating.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ARN (Amazon Resource Name) of the resource to be protected.
     *
     * The ARN should be in one of the following formats:
     * + For an Application Load Balancer: `arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> `
     * + For an Elastic Load Balancer (Classic Load Balancer): `arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/<i>load-balancer-name</i> `
     * + For an Amazon CloudFront distribution: `arn:aws:cloudfront::<i>account-id</i>:distribution/<i>distribution-id</i> `
     * + For an Global Accelerator standard accelerator: `arn:aws:globalaccelerator::<i>account-id</i>:accelerator/<i>accelerator-id</i> `
     * + For Amazon Route 53: `arn:aws:route53:::hostedzone/<i>hosted-zone-id</i> `
     * + For an Elastic IP address: `arn:aws:ec2:<i>region</i>:<i>account-id</i>:eip-allocation/<i>allocation-id</i> `
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * One or more tag key-value pairs for the Protection object that is created.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.shield.model.CreateProtectionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateProtectionRequest(")
        append("name=$name,")
        append("resourceArn=$resourceArn,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateProtectionRequest

        if (name != other.name) return false
        if (resourceArn != other.resourceArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.shield.model.CreateProtectionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Friendly name for the `Protection` you are creating.
         */
        public var name: kotlin.String? = null
        /**
         * The ARN (Amazon Resource Name) of the resource to be protected.
         *
         * The ARN should be in one of the following formats:
         * + For an Application Load Balancer: `arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> `
         * + For an Elastic Load Balancer (Classic Load Balancer): `arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/<i>load-balancer-name</i> `
         * + For an Amazon CloudFront distribution: `arn:aws:cloudfront::<i>account-id</i>:distribution/<i>distribution-id</i> `
         * + For an Global Accelerator standard accelerator: `arn:aws:globalaccelerator::<i>account-id</i>:accelerator/<i>accelerator-id</i> `
         * + For Amazon Route 53: `arn:aws:route53:::hostedzone/<i>hosted-zone-id</i> `
         * + For an Elastic IP address: `arn:aws:ec2:<i>region</i>:<i>account-id</i>:eip-allocation/<i>allocation-id</i> `
         */
        public var resourceArn: kotlin.String? = null
        /**
         * One or more tag key-value pairs for the Protection object that is created.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.shield.model.CreateProtectionRequest) : this() {
            this.name = x.name
            this.resourceArn = x.resourceArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.shield.model.CreateProtectionRequest = CreateProtectionRequest(this)
    }
}
