// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.shield.model



/**
 * Narrows the set of protection groups that the call retrieves. You can retrieve a single protection group by its name and you can retrieve all protection groups that are configured with a specific pattern, aggregation, or resource type. You can provide up to one criteria per filter type. Shield Advanced returns the protection groups that exactly match all of the search criteria that you provide.
 */
public class InclusionProtectionGroupFilters private constructor(builder: Builder) {
    /**
     * The aggregation setting of the protection groups that you want to retrieve.
     */
    public val aggregations: List<ProtectionGroupAggregation>? = builder.aggregations
    /**
     * The pattern specification of the protection groups that you want to retrieve.
     */
    public val patterns: List<ProtectionGroupPattern>? = builder.patterns
    /**
     * The ID of the protection group that you want to retrieve.
     */
    public val protectionGroupIds: List<String>? = builder.protectionGroupIds
    /**
     * The resource type configuration of the protection groups that you want to retrieve. In the protection group configuration, you specify the resource type when you set the group's `Pattern` to `BY_RESOURCE_TYPE`.
     */
    public val resourceTypes: List<ProtectedResourceType>? = builder.resourceTypes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.shield.model.InclusionProtectionGroupFilters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InclusionProtectionGroupFilters(")
        append("aggregations=$aggregations,")
        append("patterns=$patterns,")
        append("protectionGroupIds=$protectionGroupIds,")
        append("resourceTypes=$resourceTypes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggregations?.hashCode() ?: 0
        result = 31 * result + (patterns?.hashCode() ?: 0)
        result = 31 * result + (protectionGroupIds?.hashCode() ?: 0)
        result = 31 * result + (resourceTypes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InclusionProtectionGroupFilters

        if (aggregations != other.aggregations) return false
        if (patterns != other.patterns) return false
        if (protectionGroupIds != other.protectionGroupIds) return false
        if (resourceTypes != other.resourceTypes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.shield.model.InclusionProtectionGroupFilters = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The aggregation setting of the protection groups that you want to retrieve.
         */
        public var aggregations: List<ProtectionGroupAggregation>? = null
        /**
         * The pattern specification of the protection groups that you want to retrieve.
         */
        public var patterns: List<ProtectionGroupPattern>? = null
        /**
         * The ID of the protection group that you want to retrieve.
         */
        public var protectionGroupIds: List<String>? = null
        /**
         * The resource type configuration of the protection groups that you want to retrieve. In the protection group configuration, you specify the resource type when you set the group's `Pattern` to `BY_RESOURCE_TYPE`.
         */
        public var resourceTypes: List<ProtectedResourceType>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.shield.model.InclusionProtectionGroupFilters) : this() {
            this.aggregations = x.aggregations
            this.patterns = x.patterns
            this.protectionGroupIds = x.protectionGroupIds
            this.resourceTypes = x.resourceTypes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.shield.model.InclusionProtectionGroupFilters = InclusionProtectionGroupFilters(this)
    }
}
