// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.shield.model



public class ListAttacksRequest private constructor(builder: Builder) {
    /**
     * The end of the time period for the attacks. This is a `timestamp` type. The request syntax listing for this call indicates a `number` type, but you can provide the time in any valid [timestamp format](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp) setting.
     */
    public val endTime: aws.sdk.kotlin.services.shield.model.TimeRange? = builder.endTime
    /**
     * The greatest number of objects that you want Shield Advanced to return to the list request. Shield Advanced might return fewer objects than you indicate in this setting, even if more objects are available. If there are more objects remaining, Shield Advanced will always also return a `NextToken` value in the response.
     *
     * The default setting is 20.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a `NextToken` value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request.
     *
     * You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the `MaxResults` setting. Shield Advanced will not return more than `MaxResults` objects, but may return fewer, even if more objects are still available.
     *
     * Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a `NextToken` value.
     *
     * On your first call to a list operation, leave this setting empty.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The ARNs (Amazon Resource Names) of the resources that were attacked. If you leave this blank, all applicable resources for this account will be included.
     */
    public val resourceArns: List<String>? = builder.resourceArns
    /**
     * The start of the time period for the attacks. This is a `timestamp` type. The request syntax listing for this call indicates a `number` type, but you can provide the time in any valid [timestamp format](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp) setting.
     */
    public val startTime: aws.sdk.kotlin.services.shield.model.TimeRange? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.shield.model.ListAttacksRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListAttacksRequest(")
        append("endTime=$endTime,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("resourceArns=$resourceArns,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resourceArns?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListAttacksRequest

        if (endTime != other.endTime) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (resourceArns != other.resourceArns) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.shield.model.ListAttacksRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The end of the time period for the attacks. This is a `timestamp` type. The request syntax listing for this call indicates a `number` type, but you can provide the time in any valid [timestamp format](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp) setting.
         */
        public var endTime: aws.sdk.kotlin.services.shield.model.TimeRange? = null
        /**
         * The greatest number of objects that you want Shield Advanced to return to the list request. Shield Advanced might return fewer objects than you indicate in this setting, even if more objects are available. If there are more objects remaining, Shield Advanced will always also return a `NextToken` value in the response.
         *
         * The default setting is 20.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a `NextToken` value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request.
         *
         * You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the `MaxResults` setting. Shield Advanced will not return more than `MaxResults` objects, but may return fewer, even if more objects are still available.
         *
         * Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a `NextToken` value.
         *
         * On your first call to a list operation, leave this setting empty.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The ARNs (Amazon Resource Names) of the resources that were attacked. If you leave this blank, all applicable resources for this account will be included.
         */
        public var resourceArns: List<String>? = null
        /**
         * The start of the time period for the attacks. This is a `timestamp` type. The request syntax listing for this call indicates a `number` type, but you can provide the time in any valid [timestamp format](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp) setting.
         */
        public var startTime: aws.sdk.kotlin.services.shield.model.TimeRange? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.shield.model.ListAttacksRequest) : this() {
            this.endTime = x.endTime
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.resourceArns = x.resourceArns
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.shield.model.ListAttacksRequest = ListAttacksRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.shield.model.TimeRange] inside the given [block]
         */
        public fun endTime(block: aws.sdk.kotlin.services.shield.model.TimeRange.Builder.() -> kotlin.Unit) {
            this.endTime = aws.sdk.kotlin.services.shield.model.TimeRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.shield.model.TimeRange] inside the given [block]
         */
        public fun startTime(block: aws.sdk.kotlin.services.shield.model.TimeRange.Builder.() -> kotlin.Unit) {
            this.startTime = aws.sdk.kotlin.services.shield.model.TimeRange.invoke(block)
        }
    }
}
