// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.shield.model



public class ListResourcesInProtectionGroupRequest private constructor(builder: Builder) {
    /**
     * The greatest number of objects that you want Shield Advanced to return to the list request. Shield Advanced might return fewer objects than you indicate in this setting, even if more objects are available. If there are more objects remaining, Shield Advanced will always also return a `NextToken` value in the response.
     *
     * The default setting is 20.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a `NextToken` value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request.
     *
     * You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the `MaxResults` setting. Shield Advanced will not return more than `MaxResults` objects, but may return fewer, even if more objects are still available.
     *
     * Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a `NextToken` value.
     *
     * On your first call to a list operation, leave this setting empty.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it.
     */
    public val protectionGroupId: kotlin.String? = builder.protectionGroupId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.shield.model.ListResourcesInProtectionGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListResourcesInProtectionGroupRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("protectionGroupId=$protectionGroupId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (protectionGroupId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListResourcesInProtectionGroupRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (protectionGroupId != other.protectionGroupId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.shield.model.ListResourcesInProtectionGroupRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The greatest number of objects that you want Shield Advanced to return to the list request. Shield Advanced might return fewer objects than you indicate in this setting, even if more objects are available. If there are more objects remaining, Shield Advanced will always also return a `NextToken` value in the response.
         *
         * The default setting is 20.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * When you request a list of objects from Shield Advanced, if the response does not include all of the remaining available objects, Shield Advanced includes a `NextToken` value in the response. You can retrieve the next batch of objects by requesting the list again and providing the token that was returned by the prior call in your request.
         *
         * You can indicate the maximum number of objects that you want Shield Advanced to return for a single call with the `MaxResults` setting. Shield Advanced will not return more than `MaxResults` objects, but may return fewer, even if more objects are still available.
         *
         * Whenever more objects remain that Shield Advanced has not yet returned to you, the response will include a `NextToken` value.
         *
         * On your first call to a list operation, leave this setting empty.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it.
         */
        public var protectionGroupId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.shield.model.ListResourcesInProtectionGroupRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.protectionGroupId = x.protectionGroupId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.shield.model.ListResourcesInProtectionGroupRequest = ListResourcesInProtectionGroupRequest(this)
    }
}
