// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.shield.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.shield.model.AttackStatisticsDataItem
import aws.sdk.kotlin.services.shield.model.DescribeAttackStatisticsResponse
import aws.sdk.kotlin.services.shield.model.ShieldException
import aws.sdk.kotlin.services.shield.model.TimeRange
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeAttackStatisticsOperationDeserializer: HttpDeserialize<DescribeAttackStatisticsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAttackStatisticsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAttackStatisticsError(context, response)
        }
        val builder = DescribeAttackStatisticsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAttackStatisticsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeAttackStatisticsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ShieldException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ShieldException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAttackStatisticsOperationBody(builder: DescribeAttackStatisticsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DATAITEMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DataItems"))
    val TIMERANGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TimeRange"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATAITEMS_DESCRIPTOR)
        field(TIMERANGE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DATAITEMS_DESCRIPTOR.index -> builder.dataItems =
                    deserializer.deserializeList(DATAITEMS_DESCRIPTOR) {
                        val col0 = mutableListOf<AttackStatisticsDataItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAttackStatisticsDataItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TIMERANGE_DESCRIPTOR.index -> builder.timeRange = deserializeTimeRangeDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
