// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.shield.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.shield.model.DescribeProtectionResponse
import aws.sdk.kotlin.services.shield.model.Protection
import aws.sdk.kotlin.services.shield.model.ShieldException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeProtectionOperationDeserializer: HttpDeserialize<DescribeProtectionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeProtectionResponse {
        if (!response.status.isSuccess()) {
            throwDescribeProtectionError(context, response)
        }
        val builder = DescribeProtectionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeProtectionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeProtectionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ShieldException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ShieldException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeProtectionOperationBody(builder: DescribeProtectionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PROTECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Protection"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PROTECTION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PROTECTION_DESCRIPTOR.index -> builder.protection = deserializeProtectionDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
