// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs.model



/**
 *
 */
class AddPermissionRequest private constructor(builder: Builder) {
    /**
     * The action the client wants to allow for the specified principal. Valid values: the name of any action or `*`.
     *
     * For more information about these actions, see [Overview of Managing Access Permissions to Your Amazon Simple Queue Service Resource](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-overview-of-managing-access.html) in the *Amazon SQS Developer Guide*.
     *
     * Specifying `SendMessage`, `DeleteMessage`, or `ChangeMessageVisibility` for `ActionName.n` also grants permissions for the corresponding batch versions of those actions: `SendMessageBatch`, `DeleteMessageBatch`, and `ChangeMessageVisibilityBatch`.
     */
    val actions: List<String>? = builder.actions
    /**
     * The Amazon Web Services account numbers of the [principals](https://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P) who are to receive permission. For information about locating the Amazon Web Services account identification, see [Your Amazon Web Services Identifiers](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-making-api-requests.html#sqs-api-request-authentication) in the *Amazon SQS Developer Guide*.
     */
    val awsAccountIds: List<String>? = builder.awsAccountIds
    /**
     * The unique identification of the permission you're setting (for example, `AliceSendMessage`). Maximum 80 characters. Allowed characters include alphanumeric characters, hyphens (`-`), and underscores (`_`).
     */
    val label: kotlin.String? = builder.label
    /**
     * The URL of the Amazon SQS queue to which permissions are added.
     *
     * Queue URLs and names are case-sensitive.
     */
    val queueUrl: kotlin.String? = builder.queueUrl

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sqs.model.AddPermissionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AddPermissionRequest(")
        append("actions=$actions,")
        append("awsAccountIds=$awsAccountIds,")
        append("label=$label,")
        append("queueUrl=$queueUrl)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (awsAccountIds?.hashCode() ?: 0)
        result = 31 * result + (label?.hashCode() ?: 0)
        result = 31 * result + (queueUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AddPermissionRequest

        if (actions != other.actions) return false
        if (awsAccountIds != other.awsAccountIds) return false
        if (label != other.label) return false
        if (queueUrl != other.queueUrl) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sqs.model.AddPermissionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The action the client wants to allow for the specified principal. Valid values: the name of any action or `*`.
         *
         * For more information about these actions, see [Overview of Managing Access Permissions to Your Amazon Simple Queue Service Resource](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-overview-of-managing-access.html) in the *Amazon SQS Developer Guide*.
         *
         * Specifying `SendMessage`, `DeleteMessage`, or `ChangeMessageVisibility` for `ActionName.n` also grants permissions for the corresponding batch versions of those actions: `SendMessageBatch`, `DeleteMessageBatch`, and `ChangeMessageVisibilityBatch`.
         */
        var actions: List<String>? = null
        /**
         * The Amazon Web Services account numbers of the [principals](https://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P) who are to receive permission. For information about locating the Amazon Web Services account identification, see [Your Amazon Web Services Identifiers](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-making-api-requests.html#sqs-api-request-authentication) in the *Amazon SQS Developer Guide*.
         */
        var awsAccountIds: List<String>? = null
        /**
         * The unique identification of the permission you're setting (for example, `AliceSendMessage`). Maximum 80 characters. Allowed characters include alphanumeric characters, hyphens (`-`), and underscores (`_`).
         */
        var label: kotlin.String? = null
        /**
         * The URL of the Amazon SQS queue to which permissions are added.
         *
         * Queue URLs and names are case-sensitive.
         */
        var queueUrl: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sqs.model.AddPermissionRequest) : this() {
            this.actions = x.actions
            this.awsAccountIds = x.awsAccountIds
            this.label = x.label
            this.queueUrl = x.queueUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sqs.model.AddPermissionRequest = AddPermissionRequest(this)
    }
}
