// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs.model



/**
 * Encloses a receipt handle and an entry id for each message in ` <a>ChangeMessageVisibilityBatch</a>.`
 *
 * All of the following list parameters must be prefixed with `ChangeMessageVisibilityBatchRequestEntry.n`, where `n` is an integer value starting with `1`. For example, a parameter list for this action might look like this:
 *
 * `&ChangeMessageVisibilityBatchRequestEntry.1.Id=change_visibility_msg_2`
 *
 * `&ChangeMessageVisibilityBatchRequestEntry.1.ReceiptHandle=your_receipt_handle`
 *
 * `&ChangeMessageVisibilityBatchRequestEntry.1.VisibilityTimeout=45`
 */
class ChangeMessageVisibilityBatchRequestEntry private constructor(builder: Builder) {
    /**
     * An identifier for this particular receipt handle used to communicate the result.
     *
     * The `Id`s of a batch request need to be unique within a request.
     *
     * This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters, hyphens(-), and underscores (_).
     */
    val id: kotlin.String? = builder.id
    /**
     * A receipt handle.
     */
    val receiptHandle: kotlin.String? = builder.receiptHandle
    /**
     * The new value (in seconds) for the message's visibility timeout.
     */
    val visibilityTimeout: kotlin.Int = builder.visibilityTimeout

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChangeMessageVisibilityBatchRequestEntry(")
        append("id=$id,")
        append("receiptHandle=$receiptHandle,")
        append("visibilityTimeout=$visibilityTimeout)")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (receiptHandle?.hashCode() ?: 0)
        result = 31 * result + (visibilityTimeout)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChangeMessageVisibilityBatchRequestEntry

        if (id != other.id) return false
        if (receiptHandle != other.receiptHandle) return false
        if (visibilityTimeout != other.visibilityTimeout) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry = Builder(this).apply(block).build()

    class Builder {
        /**
         * An identifier for this particular receipt handle used to communicate the result.
         *
         * The `Id`s of a batch request need to be unique within a request.
         *
         * This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters, hyphens(-), and underscores (_).
         */
        var id: kotlin.String? = null
        /**
         * A receipt handle.
         */
        var receiptHandle: kotlin.String? = null
        /**
         * The new value (in seconds) for the message's visibility timeout.
         */
        var visibilityTimeout: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry) : this() {
            this.id = x.id
            this.receiptHandle = x.receiptHandle
            this.visibilityTimeout = x.visibilityTimeout
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry = ChangeMessageVisibilityBatchRequestEntry(this)
    }
}
