// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs.model



/**
 * The user-specified message system attribute value. For string data types, the `Value` attribute has the same restrictions on the content as the message body. For more information, see ` <a>SendMessage</a>.`
 *
 * `Name`, `type`, `value` and the message body must not be empty or null.
 */
class MessageSystemAttributeValue private constructor(builder: Builder) {
    /**
     * Not implemented. Reserved for future use.
     */
    val binaryListValues: List<ByteArray>? = builder.binaryListValues
    /**
     * Binary type attributes can store any binary data, such as compressed data, encrypted data, or images.
     */
    val binaryValue: kotlin.ByteArray? = builder.binaryValue
    /**
     * Amazon SQS supports the following logical data types: `String`, `Number`, and `Binary`. For the `Number` data type, you must use `StringValue`.
     *
     * You can also append custom labels. For more information, see [Amazon SQS Message Attributes](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes) in the *Amazon SQS Developer Guide*.
     */
    val dataType: kotlin.String? = builder.dataType
    /**
     * Not implemented. Reserved for future use.
     */
    val stringListValues: List<String>? = builder.stringListValues
    /**
     * Strings are Unicode with UTF-8 binary encoding. For a list of code values, see [ASCII Printable Characters](http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters).
     */
    val stringValue: kotlin.String? = builder.stringValue

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sqs.model.MessageSystemAttributeValue = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MessageSystemAttributeValue(")
        append("binaryListValues=$binaryListValues,")
        append("binaryValue=$binaryValue,")
        append("dataType=$dataType,")
        append("stringListValues=$stringListValues,")
        append("stringValue=$stringValue)")
    }

    override fun hashCode(): kotlin.Int {
        var result = binaryListValues?.hashCode() ?: 0
        result = 31 * result + (binaryValue?.contentHashCode() ?: 0)
        result = 31 * result + (dataType?.hashCode() ?: 0)
        result = 31 * result + (stringListValues?.hashCode() ?: 0)
        result = 31 * result + (stringValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MessageSystemAttributeValue

        if (binaryListValues != other.binaryListValues) return false
        if (binaryValue != null) {
            if (other.binaryValue == null) return false
            if (!binaryValue.contentEquals(other.binaryValue)) return false
        } else if (other.binaryValue != null) return false
        if (dataType != other.dataType) return false
        if (stringListValues != other.stringListValues) return false
        if (stringValue != other.stringValue) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sqs.model.MessageSystemAttributeValue = Builder(this).apply(block).build()

    class Builder {
        /**
         * Not implemented. Reserved for future use.
         */
        var binaryListValues: List<ByteArray>? = null
        /**
         * Binary type attributes can store any binary data, such as compressed data, encrypted data, or images.
         */
        var binaryValue: kotlin.ByteArray? = null
        /**
         * Amazon SQS supports the following logical data types: `String`, `Number`, and `Binary`. For the `Number` data type, you must use `StringValue`.
         *
         * You can also append custom labels. For more information, see [Amazon SQS Message Attributes](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes) in the *Amazon SQS Developer Guide*.
         */
        var dataType: kotlin.String? = null
        /**
         * Not implemented. Reserved for future use.
         */
        var stringListValues: List<String>? = null
        /**
         * Strings are Unicode with UTF-8 binary encoding. For a list of code values, see [ASCII Printable Characters](http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters).
         */
        var stringValue: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sqs.model.MessageSystemAttributeValue) : this() {
            this.binaryListValues = x.binaryListValues
            this.binaryValue = x.binaryValue
            this.dataType = x.dataType
            this.stringListValues = x.stringListValues
            this.stringValue = x.stringValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sqs.model.MessageSystemAttributeValue = MessageSystemAttributeValue(this)
    }
}
