// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs.model



/**
 * Encloses a `MessageId` for a successfully-enqueued message in a ` <a>SendMessageBatch</a>.`
 */
class SendMessageBatchResultEntry private constructor(builder: Builder) {
    /**
     * An identifier for the message in this batch.
     */
    val id: kotlin.String? = builder.id
    /**
     * An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see [RFC1321](https://www.ietf.org/rfc/rfc1321.txt).
     */
    val md5OfMessageAttributes: kotlin.String? = builder.md5OfMessageAttributes
    /**
     * An MD5 digest of the non-URL-encoded message body string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see [RFC1321](https://www.ietf.org/rfc/rfc1321.txt).
     */
    val md5OfMessageBody: kotlin.String? = builder.md5OfMessageBody
    /**
     * An MD5 digest of the non-URL-encoded message system attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see [RFC1321](https://www.ietf.org/rfc/rfc1321.txt).
     */
    val md5OfMessageSystemAttributes: kotlin.String? = builder.md5OfMessageSystemAttributes
    /**
     * An identifier for the message.
     */
    val messageId: kotlin.String? = builder.messageId
    /**
     * This parameter applies only to FIFO (first-in-first-out) queues.
     *
     * The large, non-consecutive number that Amazon SQS assigns to each message.
     *
     * The length of `SequenceNumber` is 128 bits. As `SequenceNumber` continues to increase for a particular `MessageGroupId`.
     */
    val sequenceNumber: kotlin.String? = builder.sequenceNumber

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sqs.model.SendMessageBatchResultEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SendMessageBatchResultEntry(")
        append("id=$id,")
        append("md5OfMessageAttributes=$md5OfMessageAttributes,")
        append("md5OfMessageBody=$md5OfMessageBody,")
        append("md5OfMessageSystemAttributes=$md5OfMessageSystemAttributes,")
        append("messageId=$messageId,")
        append("sequenceNumber=$sequenceNumber)")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (md5OfMessageAttributes?.hashCode() ?: 0)
        result = 31 * result + (md5OfMessageBody?.hashCode() ?: 0)
        result = 31 * result + (md5OfMessageSystemAttributes?.hashCode() ?: 0)
        result = 31 * result + (messageId?.hashCode() ?: 0)
        result = 31 * result + (sequenceNumber?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SendMessageBatchResultEntry

        if (id != other.id) return false
        if (md5OfMessageAttributes != other.md5OfMessageAttributes) return false
        if (md5OfMessageBody != other.md5OfMessageBody) return false
        if (md5OfMessageSystemAttributes != other.md5OfMessageSystemAttributes) return false
        if (messageId != other.messageId) return false
        if (sequenceNumber != other.sequenceNumber) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sqs.model.SendMessageBatchResultEntry = Builder(this).apply(block).build()

    class Builder {
        /**
         * An identifier for the message in this batch.
         */
        var id: kotlin.String? = null
        /**
         * An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see [RFC1321](https://www.ietf.org/rfc/rfc1321.txt).
         */
        var md5OfMessageAttributes: kotlin.String? = null
        /**
         * An MD5 digest of the non-URL-encoded message body string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see [RFC1321](https://www.ietf.org/rfc/rfc1321.txt).
         */
        var md5OfMessageBody: kotlin.String? = null
        /**
         * An MD5 digest of the non-URL-encoded message system attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see [RFC1321](https://www.ietf.org/rfc/rfc1321.txt).
         */
        var md5OfMessageSystemAttributes: kotlin.String? = null
        /**
         * An identifier for the message.
         */
        var messageId: kotlin.String? = null
        /**
         * This parameter applies only to FIFO (first-in-first-out) queues.
         *
         * The large, non-consecutive number that Amazon SQS assigns to each message.
         *
         * The length of `SequenceNumber` is 128 bits. As `SequenceNumber` continues to increase for a particular `MessageGroupId`.
         */
        var sequenceNumber: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sqs.model.SendMessageBatchResultEntry) : this() {
            this.id = x.id
            this.md5OfMessageAttributes = x.md5OfMessageAttributes
            this.md5OfMessageBody = x.md5OfMessageBody
            this.md5OfMessageSystemAttributes = x.md5OfMessageSystemAttributes
            this.messageId = x.messageId
            this.sequenceNumber = x.sequenceNumber
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sqs.model.SendMessageBatchResultEntry = SendMessageBatchResultEntry(this)
    }
}
