// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs.transform

import aws.sdk.kotlin.services.sqs.model.QueueAttributeName
import aws.sdk.kotlin.services.sqs.model.ReceiveMessageRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlFlattened
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ReceiveMessageOperationSerializer: HttpSerialize<ReceiveMessageRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ReceiveMessageRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeReceiveMessageOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeReceiveMessageOperationBody(context: ExecutionContext, input: ReceiveMessageRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val ATTRIBUTENAMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("AttributeName"), FormUrlFlattened)
    val MAXNUMBEROFMESSAGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("MaxNumberOfMessages"))
    val MESSAGEATTRIBUTENAMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("MessageAttributeName"), FormUrlFlattened)
    val QUEUEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("QueueUrl"))
    val RECEIVEREQUESTATTEMPTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ReceiveRequestAttemptId"))
    val VISIBILITYTIMEOUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("VisibilityTimeout"))
    val WAITTIMESECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("WaitTimeSeconds"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("ReceiveMessageRequest"))
        trait(QueryLiteral("Action", "ReceiveMessage"))
        trait(QueryLiteral("Version", "2012-11-05"))
        field(ATTRIBUTENAMES_DESCRIPTOR)
        field(MAXNUMBEROFMESSAGES_DESCRIPTOR)
        field(MESSAGEATTRIBUTENAMES_DESCRIPTOR)
        field(QUEUEURL_DESCRIPTOR)
        field(RECEIVEREQUESTATTEMPTID_DESCRIPTOR)
        field(VISIBILITYTIMEOUT_DESCRIPTOR)
        field(WAITTIMESECONDS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.attributeNames != null) {
            listField(ATTRIBUTENAMES_DESCRIPTOR) {
                for (el0 in input.attributeNames) {
                    serializeString(el0.value)
                }
            }
        }
        if (input.maxNumberOfMessages != 0) field(MAXNUMBEROFMESSAGES_DESCRIPTOR, input.maxNumberOfMessages)
        if (input.messageAttributeNames != null) {
            listField(MESSAGEATTRIBUTENAMES_DESCRIPTOR) {
                for (el0 in input.messageAttributeNames) {
                    serializeString(el0)
                }
            }
        }
        input.queueUrl?.let { field(QUEUEURL_DESCRIPTOR, it) }
        input.receiveRequestAttemptId?.let { field(RECEIVEREQUESTATTEMPTID_DESCRIPTOR, it) }
        if (input.visibilityTimeout != 0) field(VISIBILITYTIMEOUT_DESCRIPTOR, input.visibilityTimeout)
        if (input.waitTimeSeconds != 0) field(WAITTIMESECONDS_DESCRIPTOR, input.waitTimeSeconds)
    }
    return serializer.toByteArray()
}
