// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.sqs.model.SendMessageResponse
import aws.sdk.kotlin.services.sqs.model.SqsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class SendMessageOperationDeserializer: HttpDeserialize<SendMessageResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): SendMessageResponse {
        if (!response.status.isSuccess()) {
            throwSendMessageError(context, response)
        }
        val builder = SendMessageResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeSendMessageOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwSendMessageError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw SqsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidMessageContents" -> InvalidMessageContentsDeserializer().deserialize(context, wrappedResponse)
        "AWS.SimpleQueueService.UnsupportedOperation" -> UnsupportedOperationDeserializer().deserialize(context, wrappedResponse)
        else -> SqsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSendMessageOperationBody(builder: SendMessageResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("SendMessageResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("SendMessageResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap SendMessage response")
    }
    // end unwrap response wrapper

    val MD5OFMESSAGEATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("MD5OfMessageAttributes"))
    val MD5OFMESSAGEBODY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("MD5OfMessageBody"))
    val MD5OFMESSAGESYSTEMATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("MD5OfMessageSystemAttributes"))
    val MESSAGEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("MessageId"))
    val SEQUENCENUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("SequenceNumber"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://queue.amazonaws.com/doc/2012-11-05/"))
        trait(XmlSerialName("SendMessageResult"))
        field(MD5OFMESSAGEATTRIBUTES_DESCRIPTOR)
        field(MD5OFMESSAGEBODY_DESCRIPTOR)
        field(MD5OFMESSAGESYSTEMATTRIBUTES_DESCRIPTOR)
        field(MESSAGEID_DESCRIPTOR)
        field(SEQUENCENUMBER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MD5OFMESSAGEATTRIBUTES_DESCRIPTOR.index -> builder.md5OfMessageAttributes = deserializeString()
                MD5OFMESSAGEBODY_DESCRIPTOR.index -> builder.md5OfMessageBody = deserializeString()
                MD5OFMESSAGESYSTEMATTRIBUTES_DESCRIPTOR.index -> builder.md5OfMessageSystemAttributes = deserializeString()
                MESSAGEID_DESCRIPTOR.index -> builder.messageId = deserializeString()
                SEQUENCENUMBER_DESCRIPTOR.index -> builder.sequenceNumber = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
