// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs.transform

import aws.sdk.kotlin.services.sqs.model.MessageAttributeValue
import aws.sdk.kotlin.services.sqs.model.MessageSystemAttributeValue
import aws.sdk.kotlin.services.sqs.model.SendMessageRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlFlattened
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlMapName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SendMessageOperationSerializer: HttpSerialize<SendMessageRequest> {
    override suspend fun serialize(context: ExecutionContext, input: SendMessageRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeSendMessageOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeSendMessageOperationBody(context: ExecutionContext, input: SendMessageRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val DELAYSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("DelaySeconds"))
    val MESSAGEATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, FormUrlSerialName("MessageAttribute"), FormUrlFlattened, FormUrlMapName(key = "Name", value = "Value"))
    val MESSAGEBODY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("MessageBody"))
    val MESSAGEDEDUPLICATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("MessageDeduplicationId"))
    val MESSAGEGROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("MessageGroupId"))
    val MESSAGESYSTEMATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, FormUrlSerialName("MessageSystemAttribute"), FormUrlFlattened, FormUrlMapName(key = "Name", value = "Value"))
    val QUEUEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("QueueUrl"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("SendMessageRequest"))
        trait(QueryLiteral("Action", "SendMessage"))
        trait(QueryLiteral("Version", "2012-11-05"))
        field(DELAYSECONDS_DESCRIPTOR)
        field(MESSAGEATTRIBUTES_DESCRIPTOR)
        field(MESSAGEBODY_DESCRIPTOR)
        field(MESSAGEDEDUPLICATIONID_DESCRIPTOR)
        field(MESSAGEGROUPID_DESCRIPTOR)
        field(MESSAGESYSTEMATTRIBUTES_DESCRIPTOR)
        field(QUEUEURL_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.delaySeconds != 0) field(DELAYSECONDS_DESCRIPTOR, input.delaySeconds)
        if (input.messageAttributes != null) {
            mapField(MESSAGEATTRIBUTES_DESCRIPTOR) {
                input.messageAttributes.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeMessageAttributeValueDocument)) }
            }
        }
        input.messageBody?.let { field(MESSAGEBODY_DESCRIPTOR, it) }
        input.messageDeduplicationId?.let { field(MESSAGEDEDUPLICATIONID_DESCRIPTOR, it) }
        input.messageGroupId?.let { field(MESSAGEGROUPID_DESCRIPTOR, it) }
        if (input.messageSystemAttributes != null) {
            mapField(MESSAGESYSTEMATTRIBUTES_DESCRIPTOR) {
                input.messageSystemAttributes.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeMessageSystemAttributeValueDocument)) }
            }
        }
        input.queueUrl?.let { field(QUEUEURL_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
