// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An activation registers one or more on-premises servers or virtual machines (VMs) with Amazon Web Services
 * so that you can configure those servers or VMs using Run Command. A server or VM that has been
 * registered with Amazon Web Services Systems Manager is called a managed node.
 */
class Activation private constructor(builder: Builder) {
    /**
     * The ID created by Systems Manager when you submitted the activation.
     */
    val activationId: kotlin.String? = builder.activationId
    /**
     * The date the activation was created.
     */
    val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * A name for the managed node when it is created.
     */
    val defaultInstanceName: kotlin.String? = builder.defaultInstanceName
    /**
     * A user defined description of the activation.
     */
    val description: kotlin.String? = builder.description
    /**
     * The date when this activation can no longer be used to register managed nodes.
     */
    val expirationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.expirationDate
    /**
     * Whether or not the activation is expired.
     */
    val expired: kotlin.Boolean = builder.expired
    /**
     * The Identity and Access Management (IAM) role to assign to the managed node.
     */
    val iamRole: kotlin.String? = builder.iamRole
    /**
     * The maximum number of managed nodes that can be registered using this activation.
     */
    val registrationLimit: kotlin.Int = builder.registrationLimit
    /**
     * The number of managed nodes already registered with this activation.
     */
    val registrationsCount: kotlin.Int = builder.registrationsCount
    /**
     * Tags assigned to the activation.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.Activation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Activation(")
        append("activationId=$activationId,")
        append("createdDate=$createdDate,")
        append("defaultInstanceName=$defaultInstanceName,")
        append("description=$description,")
        append("expirationDate=$expirationDate,")
        append("expired=$expired,")
        append("iamRole=$iamRole,")
        append("registrationLimit=$registrationLimit,")
        append("registrationsCount=$registrationsCount,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activationId?.hashCode() ?: 0
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (defaultInstanceName?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (expirationDate?.hashCode() ?: 0)
        result = 31 * result + (expired.hashCode())
        result = 31 * result + (iamRole?.hashCode() ?: 0)
        result = 31 * result + (registrationLimit)
        result = 31 * result + (registrationsCount)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Activation

        if (activationId != other.activationId) return false
        if (createdDate != other.createdDate) return false
        if (defaultInstanceName != other.defaultInstanceName) return false
        if (description != other.description) return false
        if (expirationDate != other.expirationDate) return false
        if (expired != other.expired) return false
        if (iamRole != other.iamRole) return false
        if (registrationLimit != other.registrationLimit) return false
        if (registrationsCount != other.registrationsCount) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.Activation = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID created by Systems Manager when you submitted the activation.
         */
        var activationId: kotlin.String? = null
        /**
         * The date the activation was created.
         */
        var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A name for the managed node when it is created.
         */
        var defaultInstanceName: kotlin.String? = null
        /**
         * A user defined description of the activation.
         */
        var description: kotlin.String? = null
        /**
         * The date when this activation can no longer be used to register managed nodes.
         */
        var expirationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Whether or not the activation is expired.
         */
        var expired: kotlin.Boolean = false
        /**
         * The Identity and Access Management (IAM) role to assign to the managed node.
         */
        var iamRole: kotlin.String? = null
        /**
         * The maximum number of managed nodes that can be registered using this activation.
         */
        var registrationLimit: kotlin.Int = 0
        /**
         * The number of managed nodes already registered with this activation.
         */
        var registrationsCount: kotlin.Int = 0
        /**
         * Tags assigned to the activation.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.Activation) : this() {
            this.activationId = x.activationId
            this.createdDate = x.createdDate
            this.defaultInstanceName = x.defaultInstanceName
            this.description = x.description
            this.expirationDate = x.expirationDate
            this.expired = x.expired
            this.iamRole = x.iamRole
            this.registrationLimit = x.registrationLimit
            this.registrationsCount = x.registrationsCount
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.Activation = Activation(this)
    }
}
